﻿using Curse.Friends.MicroService;

namespace Curse.Friends.StatsWebService.Contracts
{
    public class HostStatusContract : BaseRequestContract
    {
        public int RegionID { get; set; }
        public string HostName { get; set; }
        public int HostTypeID { get; set; }
        public string HostTypeName { get; set; }
        public HostStatus HostStatus { get; set;  }

        protected override bool DoValidate()
        {
            if (HostTypeID <= 0)
            {
                return false;
            }

            if (string.IsNullOrWhiteSpace(HostName))
            {
                return false;
            }

            if (string.IsNullOrWhiteSpace(HostTypeName))
            {
                return false;
            }

            if ((int)HostStatus == 0)
            {
                return false;
            }

            return true;
        }
    }
}