﻿using Curse.Friends.MicroService;

namespace Curse.Friends.StatsWebService.Contracts
{
    public class StatsPayload : BaseRequestContract
    {
        public int RegionID { get; set; }
        public int HostTypeID { get; set; }
        public string HostTypeName { get; set; }
        public string HostName { get; set; }
        public string StatsJson { get; set; }

        protected override bool DoValidate()
        {
            if (HostTypeID <= 0)
            {
                _validationMessage = "HostTypeID is missing.";
                return false;
            }

            if (string.IsNullOrWhiteSpace(HostTypeName))
            {
                _validationMessage = "HostTypeName is missing.";
                return false;
            }

            if (string.IsNullOrWhiteSpace(HostName))
            {
                _validationMessage = "HostTypeName is missing.";
                return false;
            }


            if (string.IsNullOrWhiteSpace(StatsJson))
            {
                _validationMessage = "HostTypeName is missing.";
                return false;
            }

            return true;
        }
    }
}