﻿using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.StatsWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.StatsService; }
        }

        protected override string ServiceDescription
        {
            get { return "Provides all Curse platform services with a central stats reporting store."; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database; }
        }

        protected override bool StatsEnabled
        {
            get { return false; }
        }

        protected override void CustomApplicationStartup()
        {
            StatsManager.Start();
        }

        protected override void CustomApplicationShutdown()
        {
            StatsManager.Stop();
        }
    }
}
