﻿using System.Xml.Serialization;
using Curse.Friends.BattleNet;
using Curse.Friends.Configuration;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;

namespace Curse.Friends.SyncWebService.Configuration
{
    [XmlRoot("BattleNet")]
    public class BattleNetConfiguration
    {
        private static readonly BattleNetConfiguration _instance;

        public static BattleNetConfiguration Instance { get { return _instance; } }

        static BattleNetConfiguration()
        {
            _instance = ConfigHelper.LoadConfig<BattleNetConfiguration>(FriendsServiceConfiguration.Mode, "BattleNet");

            switch (RegionDiscovery.GetCurrentRegionKey())
            {
                case "EU-West":
                    _instance.LocalRegion = BattleNetRegion.EU;
                    break;
                case "AP-Southeast":
                    _instance.LocalRegion = BattleNetRegion.TW;
                    break;
                default:
                    _instance.LocalRegion = BattleNetRegion.US;
                    break;
            }
        }

        [XmlElement]
        public BattleNetApplication Application { get; set; }

        [XmlElement("Scope")]
        public string[] Scopes { get; set; }

        [XmlIgnore]
        public BattleNetRegion LocalRegion { get; set; }
    }
}