﻿
using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.SyncWebService.Configuration
{
    [XmlRoot("SyncService")]
    public class SyncServiceConfiguration
    {
        private static readonly SyncServiceConfiguration _instance;

        public static SyncServiceConfiguration Instance { get { return _instance; } }

        static SyncServiceConfiguration()
        {
            var config = ConfigHelper.LoadConfig<SyncServiceConfiguration>(FriendsServiceConfiguration.Mode, "SyncService");
            config.Twitch = TwitchConfiguration.Instance;
            config.BattleNet = BattleNetConfiguration.Instance;

            _instance = config;
        }

        [XmlIgnore]
        public TwitchConfiguration Twitch { get; set; }

        [XmlIgnore]
        public BattleNetConfiguration BattleNet { get; set; }

        [XmlElement]
        public string SyncServiceDomain { get; set; }
    }
}