﻿using System;
using System.IO;
using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;

namespace Curse.Friends.SyncWebService.Configuration
{
    [XmlRoot("Twitch")]
    public class TwitchConfiguration
    {
        private static readonly TwitchConfiguration _instance;

        public static TwitchConfiguration Instance { get { return _instance; } }

        static TwitchConfiguration()
        {
            _instance = ConfigHelper.LoadConfig<TwitchConfiguration>(FriendsServiceConfiguration.Mode, "Twitch");
        }

        [XmlElement]
        public string ClientSecret { get; set; }

        [XmlElement]
        public string RedirectUri { get; set; }

        [XmlElement("Scope")]
        public string[] Scopes { get; set; }
    }
}