﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace Curse.Friends.SyncWebService.Contracts
{
    public class LinkExternalAccountRequest
    {
        /// <summary>
        /// Optional URL to redirect to after a successful account link.
        /// </summary>
        public string SuccessRedirectUrl { get; set; }

        /// <summary>
        /// Optional URL to redirect to after a failed account link.
        /// </summary>
        public string FailureRedirectUrl { get; set; }

        /// <summary>
        /// Optional switch to force the user to enter credentials to Twitch instead of allowing Twitch to use its own cookies.
        /// </summary>
        public bool? ForceVerify { get; set; }

        /// <summary>
        /// Optional region ID for a game account
        /// </summary>
        public int? GameRegion { get; set; }
    }
}