﻿using System;
using System.Web.Mvc;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.SyncWebService.Configuration;
using Curse.Friends.SyncWebService.Utilities;
using Curse.Friends.TwitchApi;
using Curse.Logging;

namespace Curse.Friends.SyncWebService.Controllers
{    
    public class TwitchCallbackController : BaseCallbackController<TwitchCallbackSeed>
    {
        private static readonly LogCategory Logger = new LogCategory("TwitchCallbackController");

        [HttpGet]
        public ActionResult Callback(string code = null, string state = null, string error = null, string error_description = null)
        {
            return base.Callback(Logger, code, state, error);
        }

        protected override bool CustomCallbackActions(string code, string state, Data.User user, UserRegion userRegion, TwitchCallbackSeed seed)
        {
            try
            {
                // Get account data from twitch
                var account = TwitchModelHelper.CreateOrUpdateAccount(code, state, FriendsServiceConfiguration.Instance.TwitchClientID, SyncServiceConfiguration.Instance.Twitch.ClientSecret,
                    SyncServiceConfiguration.Instance.Twitch.RedirectUri);

                // Get community data from twitch
                var community = TwitchModelHelper.CreateOrUpdateCommunity(account.ExternalID, account);
                if (community.IsHostable && community.MappedGroups != null && community.MappedGroups.Count > 0)
                {
                    ExternalCommunityCoordinator.OwnerReauthenticated(community, account);
                }

                var link = account.MapUser(userRegion.UserID, userRegion.RegionID);
                user.UpdateTwitchID(link.ExternalID, account);
                TwitchAccountSyncWorker.Create(link.ExternalID, true);

                if (!user.HasSyncedAccount)
                {
                    user.HasSyncedAccount = true;
                    user.Update(u => u.HasSyncedAccount);
                }

                TwitchAccountResolver.UserLinkChanged(user.UserID, account);

                return true;
            }
            catch (DataValidationException ex)
            {
                Logger.Debug(ex, "Error during Twitch callback");
                return false;
            }
        }
    }
}