﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Text;
using System.Web;
using System.Web.Http;
using System.Web.Http.Description;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.TwitchApi;
using Curse.Logging;

namespace Curse.Friends.SyncWebService.Controllers
{
#if !DEBUG
    [ApiExplorerSettings(IgnoreApi = true)]
#endif
    [RoutePrefix("twitch")]
    public class TwitchInteropController : MicroServiceController
    {
        [HttpGet]
        [Route("bits/config")]
        [ResponseType(typeof (object))]
        public IHttpActionResult GetCheerEmoteConfig()
        {
            return ProxyGet("https://www.twitch.tv/bits/config.json");
        }

        [HttpGet]
        [Route("chat/{externalID}/properties")]
        [ResponseType(typeof (object))]
        public IHttpActionResult GetChatProperties(string externalID)
        {
            var community = ExternalCommunity.GetLocal(externalID, AccountType.Twitch);
            if (community == null)
            {
                return NotFound();
            }

            return ProxyGet(string.Format("https://api.twitch.tv/api/channels/{0}/chat_properties", community.ExternalName));
        }

        // TODO: Use these if we determine it should be done client-side
        //[HttpGet]
        //[Route("chat/{externalID}/recent-messages")]
        //[ResponseType(typeof (object))]
        //public IHttpActionResult GetChatRecentMessages(string externalID)
        //{
        //    return ProxyGet(string.Format("https://tmi.twitch.tv/api/rooms/{0}/recent_messages", externalID));
        //}

        [HttpGet]
        [Route("hosts/{externalID}")]
        [ResponseType(typeof(object))]
        public IHttpActionResult GetHostInfo(string externalID)
        {
            return ProxyGet(string.Format("https://tmi.twitch.tv/hosts?include_logins=1&host={0}&_={1}", externalID, DateTime.UtcNow.ToEpochMilliseconds()));
        }

        #region Helpers

        private IHttpActionResult ProxyGet(string requestUrl, string authToken = null)
        {
            try
            {
                using (var client = TwitchApiHelper.Default.CreateClient(authToken))
                {
                    var resp = client.GetAsync(requestUrl).Result;
                    var content = resp.Content.ReadAsStringAsync().Result;
                    return resp.IsSuccessStatusCode ? CreateProxyResult(content) : StatusCode(resp.StatusCode, content);
                }
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "Unable to proxy a request to requestUrl");
                return InternalServerError();
            }
        }

        private IHttpActionResult CreateProxyResult(string content)
        {
            var message = Request.CreateResponse(HttpStatusCode.OK);
            message.Content = new StringContent(content, Encoding.UTF8, "application/json");
            return ResponseMessage(message);
        }

        #endregion



    }
}