﻿using System.Net;
using System.Web.Mvc;
using System.Web.Routing;
using Curse.Friends.BattleNet;
using Curse.Friends.Configuration;
using Curse.Friends.MicroService;
using Curse.Friends.SyncWebService.Configuration;
using Curse.Friends.TwitchApi;

namespace Curse.Friends.SyncWebService
{
    public class WebApiApplication : MicroServiceApplication
    {
        protected override ServiceHostType ServiceType
        {
            get { return ServiceHostType.SyncWebService; }
        }

        protected override string ServiceDescription
        {
            get { return "The account sync service provides functionality for linking a user's account to other external accounts."; }
        }

        protected override void CustomApplicationStartup()
        {
            // battlenet oauth and api breaks if we allow tls 1.0
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls11 | SecurityProtocolType.Tls12;
            TwitchApiHelper.Initialize(FriendsServiceConfiguration.Instance.TwitchClientID, SyncServiceConfiguration.Instance.Twitch.ClientSecret);
            RouteTable.Routes.MapRoute("OAuthCallback", "oauth/{controller}/{action}");
            BattleNetApiHelper.Initialize(SyncServiceConfiguration.Instance.BattleNet.Application);
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.All; }
        }
    }
}
