﻿using System.Diagnostics;
using System.Net;
using System.Security.Cryptography.X509Certificates;
using System.Threading;
using Aerospike.Client;
using Curse.Aerospike;
using Curse.Friends.Configuration;
using Curse.Friends.Data;
using Curse.Friends.Data.Models;
using Curse.Friends.Enums;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Logging;

namespace Curse.Friends.Tools
{
    class Program
    {
        static int[] PrimaryTestUserIDs = new int[] { 1, 817369, 7231064, 14923652, 59128, 65, 438695, 16203539, 2547696, 2794552, 4257619, 4, 128, 2566586, 11727540, 16470923, 16018173 };
        static int[] EarlyTestUserIDs = new int[] 
        { 
            1,  // Michael
            817369, // Tyler            
            2794552, // Chip
            7231064, // Kashin

        };

        static readonly int[] DebugTestUserIDs = { 16470923 };

        static HashSet<int> TestUserIDs;

        static void Main(string[] args)
        {
            try
            {
                Logger.Init(@"C:\Curse\Logs\Curse.Fiends.Tools\");
                Logger.Info("Starting...");

#if DEBUG
                StorageConfiguration.Initialize("ToolsTester", "US-East", ConfigurationMode.Release);
#else
                StorageConfiguration.Initialize("ToolsTester", "US-East");
#endif

                PrintGroupDetails(1, Guid.Parse("d099dd95-85e3-4fc0-9118-2d513374904c"));

                PrintGroupDetails(3, Guid.Parse("d099dd95-85e3-4fc0-9118-2d513374904c"));
                //FixCorruptedFriendships(AerospikeConfiguration.Configurations.FirstOrDefault(p => p.RegionIdentifier == 5 && p.ClusterAffinity == 1));
                //FixCorruptedFriends(AerospikeConfiguration.Configurations.FirstOrDefault(p => p.RegionIdentifier == 5 && p.ClusterAffinity == 1), 17085330);
                //WipeEndpointData();
                //FixOfflineUsers();
                return;

                Console.WriteLine("Done!");

                TestUserIDs = new HashSet<int>(DebugTestUserIDs);

                // Get the promo
                var promo = GroupPromo.GetLocal("21d41365-9e22-41f7-b710-f191a76b59e6");
                var groups = promo.GroupIDs.Select(Group.GetLocal).ToArray();

                foreach (var group in groups.OrderByDescending(p => p.MemberCount))
                {
                    var convo = Conversation.GetByTypeAndID(ConversationType.Group, group.GroupID.ToString());
                    var messageCount = convo != null ? convo.History.Count : 0;
                    Console.WriteLine(group.Title + " (" + group.MemberCount + " members, " + messageCount + " messages)");

                }

                //WipeTestGroups(StorageConfiguration.CurrentRegion.ID);
                RemoveLegacyBins(AerospikeConfiguration.Configurations.FirstOrDefault(p => p.ClusterAffinity == 1 && p.IsLocal));

                //Console.WriteLine("Suggestions");
                //var suggestions = FriendSuggestion.GetAllLocal(p => p.UserID, 14152787);
                //foreach (var suggestion in suggestions)
                //{
                //    Console.WriteLine(suggestion.Username);
                //}

                //Console.WriteLine("Friends");

                //var friends = Friendship.GetAllLocal(p => p.UserID, 14152787);
                //foreach (var friend in friends)
                //{
                //    Console.WriteLine(friend.OtherUsername + " (" + friend.OtherUserNickname + ")");
                //}

                //var userStats = UserStatistics.GetLocal(14152787);

                //Console.WriteLine(userStats.FriendIDs);

                //FindInvalidOnlineUsers(AerospikeConfiguration.LocalConfiguration);
                //FindUser(16254523);
                //GetEndpointStats(AerospikeConfiguration.LocalConfiguration);
                //FindInvalidOfflineUsers(AerospikeConfiguration.LocalConfiguration);
                //Friendship.GetLocal(0, 1);
                //User.GetLocal(0, 1);
                //FriendHint.GetLocal(0, 1);
                //FriendSuggestion.GetLocal(0, 1);

                //RebuildIndex<Friendship>();
                //RebuildIndex<User>();
                //RebuildIndex<FriendSuggestion>();
                //RebuildIndex<FriendHint>();



                //WipeIdentities(false);
                //FindUser(1);
                //FindInvalidOnlineUsers();
                //FindInvalidOfflineUsers();            
                //FindInvalidEndpoints();
                //FindInvalidStates();
                //WipeSuggestions(true, new[] { FriendSuggestionType.GameFriend, FriendSuggestionType.PlatformFriend });
                //ValidateGroupData();
                Console.WriteLine("Done!");
                Console.ReadKey(true);
                return;
                FindInvalidStates();

                //
                //ResetMutualFriendSuggestions();

                //WipeIdentities();
                //WipeSuggestions();
                //TestCreatingFriendHint();
                //TestCreatingPlatformSuggestions();
                //UpdateData();
                //WipeTesters();
                //TestCreatingFriendHint();
                //TestCreatingFriendHint();
                Console.WriteLine("Done! Press any key to exit.");
                Console.ReadKey();
                return;
                TestScans();
                WipeSuggestions();
                FindInvalidStates();
            }
            catch (Exception)
            {


            }
            finally
            {
                StorageConfiguration.Shutdown();
            }
            Console.WriteLine("Initializing Config...");
        }

        static void PrintGroupDetails(int regionID, Guid groupID)
        {

            // Get the group details
            var group = Group.Get(regionID, groupID);
            if (group == null)
            {
                Console.WriteLine("Unknown group!");
                return;
            }

            Console.WriteLine("Title: " + group.Title);
            Console.WriteLine("Session Machine: " + group.MachineName);
            Console.WriteLine("Home Region: " + string.Join(",", group.RegionID));
            if (group.ActiveRegionIDs != null)
            {
                Console.WriteLine("Active Regions: " + string.Join(",", group.ActiveRegionIDs));
            }
            Console.WriteLine("Date Created: " + string.Join(",", group.DateCreated));
            Console.WriteLine("Member Count: " + string.Join(",", group.MemberCount));


            var memberlist = GroupMemberList.Get(regionID, groupID);
            var members = memberlist.Members.GetValues();
            Console.WriteLine("Members");
            foreach (var groupMember in members)
            {
                Console.WriteLine(groupMember.UserID + ", username: " + groupMember.Username + ", region: " + groupMember.RegionID + ", role: " + groupMember.Role);
            }

            var eventLog = GroupEventLog.Get(regionID, groupID);

            if (eventLog == null)
            {
                Console.WriteLine("Event log not found!");
                return;
            }

            Console.WriteLine("Events");
            var events = eventLog.Events.GetValues();
            foreach (var e in events)
            {
                Console.WriteLine(e.Type.ToString() + " at " + e.Timestamp + " by user " + e.InitiatingUserID + ": " + e.EventData);   
            }

            Console.ReadLine();
        }


        private static void RebuildIndex<T>() where T : BaseTable<T>, new()
        {
            Console.WriteLine("--------------------------------------------------------------");
            Console.WriteLine("Rebuilding " + typeof(T).Name + "...");
            var updated = 0;
            var processed = 0;

            var config = AerospikeConfiguration.Configurations.FirstOrDefault(p => p.IsLocal);
            BaseTable<T>.UpdateAllRecords(config, (key, record) =>
            {
                ++processed;
                if (processed % 1000 == 0)
                {
                    Console.WriteLine(processed);
                }

                if (!record.bins.ContainsKey("IndexMode"))
                {
                    ++updated;
                    config.Client.Put(null, key, new Bin("IndexMode", (int)IndexMode.Default));
                }
            });

            Console.WriteLine("Finished updating " + typeof(T).Name + "! Processed: " + processed.ToString("####,##0") + ". Updated: " + updated.ToString("####,##0"));
            Console.WriteLine("Press any key to continue...");
            Console.ReadKey(true);
        }

        private static void RebuildUserStats()
        {
            foreach (var config in AerospikeConfiguration.Configurations)
            {
                RebuildUserStats(config.RegionIdentifier);
            }
            return;
        }

        private static void FindUser(int userID)
        {
            User user = null;
            foreach (var config in AerospikeConfiguration.Configurations)
            {

                user = User.Get(config.RegionIdentifier, userID);
                if (user != null)
                {
                    Console.WriteLine("Found user in region " + config.RegionGroup);

                    // Get this user's friend records
                    var friendships = Friendship.GetAll(config, p => p.OtherUserID, userID);
                    foreach (var f in friendships)
                    {
                        Console.WriteLine(f.OtherUserConnectionStatus);
                    }

                    break;
                }
            }

            if (user == null)
            {
                Console.WriteLine("Unable to find user!");
                return;
            }

            // Get user's endpoints
            var endpoints = ClientEndpoint.GetAllLocal(p => p.UserID, user.UserID);
            foreach (var ep in endpoints)
            {
                Console.WriteLine("Connected: " + ep.IsConnected + ", Server: " + ep.ServerName + ", Conn Date: " + ep.ConnectedDate.ToLocalTime() + ", Heartbeat: " + ep.HeartbeatDate.ToLocalTime());
            }

            while (true)
            {

                Console.WriteLine("Find another user?");
                var line = Console.ReadLine();
                if (string.IsNullOrEmpty(line))
                {
                    return;
                }

                int newUserID;
                if (int.TryParse(line, out newUserID))
                {
                    FindUser(newUserID);
                }
                else
                {
                    return;
                }
            }


        }

        private static void RebuildUserStats(int regionID)
        {
            Console.WriteLine("Rebuilding user stats for region " + regionID);
            var total = 0;
            User.BatchOperate(regionID, 100, (batch) =>
            {

                foreach (var user in batch)
                {
                    var friends = Friendship.GetAllConfirmed(regionID, user.UserID);
                    user.UpdateFriendCount(regionID, friends);
                    user.UpdateUserStats(friends);
                }
                Console.WriteLine(total + batch.Count() + " completed");
            });

            Console.WriteLine("Done!");

        }

        private static void ResetMutualFriendSuggestions()
        {
            foreach (var config in AerospikeConfiguration.Configurations)
            {
                WipeMutualFriendSuggestions(config.RegionIdentifier);
                ResetFriendSuggestionDate(config.RegionIdentifier);
            }
            return;
        }

        private static void ResetFriendSuggestionDate(int regionID)
        {
            Console.WriteLine("Resetting friend suggestion dates for region " + regionID);
            var total = 0;
            User.BatchOperate(regionID, 100, (batch) =>
            {

                foreach (var user in batch)
                {
                    user.LastFriendsSuggestion = new DateTime(1985, 1, 1, 12, 0, 0);
                }

                total += batch.Count();
                Console.WriteLine(total + " completed");
            });

            Console.WriteLine("Done!");

        }

        static void WipeMutualFriendSuggestions(int regionID)
        {
            Console.WriteLine("Wiping suggestions....");
            var total = 0;
            FriendSuggestion.BatchOperate(regionID, 100, (batch) =>
            {

                foreach (var sug in batch)
                {
                    if (sug.Type == FriendSuggestionType.MutualFriend && sug.Status == FriendSuggestionStatus.Pending)
                    {
                        sug.Delete();
                    }
                }

                total += batch.Count();
                Console.WriteLine(total + " completed");
            });

            Console.WriteLine("Done wiping suggestions!");
        }

        private static void WipeAllRegions()
        {
            foreach (var config in AerospikeConfiguration.Configurations)
            {
                WipeRegion(config.RegionIdentifier);
            }
            return;
        }

        private static void TestCreatingFriendHint()
        {
            var hint = new FriendHint
            {
                UserID = 817369,
                AvatarUrl = null,
                Description = null,
                DisplayName = "Tyler McDowall",
                Platform = FriendPlatform.Skype,
                SearchTerm = "tmcdowall-curse",
                Status = FriendHintStatus.Normal,
                Type = FriendHintType.Platform,
                Verification = FriendHintVerification.ClientObserved
            };

            hint.InsertLocal();

            hint = new FriendHint
            {
                UserID = 817369,
                AvatarUrl = null,
                Description = null,
                DisplayName = "Tyler McDowall",
                Platform = FriendPlatform.BattleNet,
                SearchTerm = "Ace#1476",
                Status = FriendHintStatus.Normal,
                Type = FriendHintType.Platform,
                Verification = FriendHintVerification.ClientObserved
            };

            hint = new FriendHint
            {
                UserID = 817369,
                AvatarUrl = null,
                Description = null,
                DisplayName = "Crs Acenth",
                SearchTerm = "Crs Acenth",
                Status = FriendHintStatus.Normal,
                Type = FriendHintType.Game,
                GameID = 341,
                Verification = FriendHintVerification.ClientObserved
            };

            hint.InsertLocal();

            new FriendHintSearchIndexer { UserID = 817369 }.Enqueue();
        }

        private static void TestCreatingPlatformSuggestions()
        {
            var suggestion = new FriendSuggestion
            {
                UserID = 1,
                OtherUserID = 817369,
                AvatarUrl = null,
                FriendCount = 100,
                Platform = FriendPlatform.Skype,
                RequestAvatarUrl = "http://clientupdate-v6.cursecdn.com/PlatformAssets/4/Icon64.png",
                RequestUsername = "Michael Comperda",
                Status = FriendSuggestionStatus.Pending,
                Type = FriendSuggestionType.PlatformFriend,
                Username = "Tyler McDowall"
            };

            suggestion.InsertLocal();

        }

        static void UpdateData()
        {

#if !DEBUG
            Console.WriteLine("This cannot be run outside of debug mode!");
            return;
            
#endif
            UserRegion.BatchOperate(0, 1000, (list) =>
            {

                foreach (var ur in list)
                {
                    if (ur == null)
                    {
                        continue;
                    }

                    if (ur.RegionID != 0)
                    {
                        ur.RegionID = 0;
                        ur.Update();
                    }
                }
            });


            Friendship.BatchOperate(0, 1000, (list) =>
            {
                foreach (var ur in list)
                {
                    if (ur == null)
                    {
                        continue;
                    }

                    if (ur.OtherUserRegionID != 0)
                    {
                        ur.OtherUserRegionID = 0;
                        ur.Update();
                    }
                }
            });
        }

        static void TestScans()
        {
            FriendHint.BatchOperate(FriendHint.GetConfiguration(3), 1000, (h) =>
                {

                });
        }

        static void WipeTesters()
        {
            WipeIdentities();
            WipeFriends();
            WipeSuggestions();

            new FriendHintSearchIndexer { RebuildIndex = true }.Enqueue();
        }

        static void WipeIdentities(bool onlyDeleted = false)
        {
            Console.WriteLine("Wiping identities....");

            foreach (var user in TestUserIDs)
            {
                var identities = FriendHint.GetAllLocal(p => p.UserID, user);
                Console.WriteLine("Wiping " + identities.Length + " identities for user " + user);

                foreach (var identity in identities)
                {
                    if (!onlyDeleted || identity.Status == FriendHintStatus.Deleted)
                    {
                        identity.Delete();
                    }
                }

                new FriendHintSearchIndexer() { UserID = user }.Enqueue();
            }

            Console.WriteLine("Done wiping identities!");
        }

        static void WipeSuggestions(bool onlyMine = true, FriendSuggestionType[] types = null)
        {
            Console.WriteLine("Wiping suggestions....");

            foreach (var user in TestUserIDs)
            {
                var suggestions = FriendSuggestion.GetAllLocal(p => p.UserID, user);

                var gameSuggestions = suggestions.Where(p => p.Type == FriendSuggestionType.GameFriend);

                foreach (var sug in gameSuggestions)
                {
                    Console.WriteLine(sug.Username);
                }

                if (!onlyMine)
                {
                    var otherSuggestions = FriendSuggestion.GetAllLocal(p => p.OtherUserID, user);
                    var allSuggestions = suggestions.Concat(otherSuggestions);
                }

                if (types != null)
                {
                    suggestions = suggestions.Where(p => types.Contains(p.Type)).ToArray();
                }

                Console.WriteLine("Wiping " + suggestions.Length + " suggestions for user " + user);
                foreach (var suggestion in suggestions)
                {
                    suggestion.Delete();
                }
            }

            Console.WriteLine("Done wiping suggestions!");
        }

        static void WipeFriends(HashSet<int> userIDs = null)
        {
            Console.WriteLine("Wiping friends....");

            userIDs = userIDs ?? TestUserIDs;

            foreach (var user in userIDs)
            {
                // Clear people who are friends with me
                var otherFriends = Friendship.GetAllLocal(p => p.OtherUserID, user).ToArray();

                // Clear my friends
                var friends = Friendship.GetAllLocal(p => p.UserID, user).ToArray();

                Console.WriteLine("Wiping " + friends.Length + " friends for user " + user);
                foreach (var f in friends)
                {
                    f.Delete();
                }

                Console.WriteLine("Wiping " + friends.Length + " other friends for user " + user);
                foreach (var f in otherFriends)
                {
                    f.Delete();
                }
            }

            Console.WriteLine("Done wiping friends!");
        }

        static void WipeRegion(int region)
        {
            WipeTable<Friendship>(region);
            WipeTable<FriendSuggestion>(region);
            WipeTable<User>(region);

            if (region == StorageConfiguration.CurrentRegion.ID)
            {
                WipeTable<UserRegion>(region);
                WipeTable<FriendHint>(region);
                new FriendHintSearchIndexer { RebuildIndex = true }.Enqueue();
            }
        }

        static void WipeTable<T>(int regionID) where T : BaseTable<T>, new()
        {
            Console.WriteLine("Wiping " + typeof(T).Name + " in region " + regionID);
            var config = AerospikeConfiguration.Configurations.FirstOrDefault(p => p.RegionIdentifier == regionID);
            var counter = 0;
            BaseTable<T>.UpdateAllRecords(config, (key, record) =>
            {
                if (++counter % 100 == 0)
                {
                    Console.WriteLine("Deleting  " + counter + " items...");
                }

                config.Client.Delete(null, key);
            });

            Console.WriteLine("Done!");
        }


        static void WipeTestGroups(int regionID)
        {

            GroupMembership.BatchOperate(regionID, 100, list =>
            {
                Console.WriteLine("Processing " + list.Count() + " items...");

                foreach (var model in list)
                {
                    if (model.UserID == 0 || model.UserID >= Int32.MaxValue - 100 || model.HasHydrationErrors)
                    {
                        model.DeleteRemote(regionID);
                    }

                    // Integrity Check
                    if (Group.GetLocal(model.GroupID) == null)
                    {
                        model.DeleteRemote(regionID);
                    }
                }
            });

            Group.BatchOperate(regionID, 100, list =>
            {
                Console.WriteLine("Processing " + list.Count() + " items...");

                foreach (var model in list)
                {
                    if (model.Title == null || model.Title.Length > 30 || model.Title.Contains("Tests"))
                    {
                        model.DeleteRemote(regionID);
                    }
                }
            });

            GroupMemberList.BatchOperate(regionID, 100, list =>
            {
                Console.WriteLine("Processing " + list.Count() + " items...");

                foreach (var model in list)
                {
                    // Integrity Check
                    if (Group.GetLocal(model.GroupID) == null)
                    {
                        model.DeleteRemote(regionID);
                    }
                }
            });


            Console.WriteLine("Done!");
        }

        private static void RemoveLegacyBins(AerospikeConfiguration configuration)
        {
            Group.UpdateAllRecords(configuration, (key, record) =>
            {
                if (record.bins.ContainsKey("Members"))
                {
                    configuration.Client.Put(null, key, Bin.AsNull("Members"));
                }

                if (record.bins.ContainsKey("OwnerIDs"))
                {
                    configuration.Client.Put(null, key, Bin.AsNull("OwnerIDs"));
                }
            }, false);
        }


        static void FindInvalidStates()
        {
            // Get all endpoints with an online status
            var endpoints = ClientEndpoint.GetAllLocal().Where(p => p.RegionID == 1).GroupBy(p => p.UserID);
            var usersChecked = new HashSet<int>();

            var counter = 0;
            var total = endpoints.Count();

            foreach (var group in endpoints)
            {
                Console.Title = ++counter + " of " + total;
                var userID = group.Key;

                var disconnected = !group.Any(p => p.IsConnected && p.HeartbeatDate >= DateTime.UtcNow.AddMinutes(-30));

                if (!disconnected)
                {
                    continue;
                }

                var userRegion = UserRegion.GetLocal(userID);

                if (userRegion == null)
                {
                    continue;
                }

                var user = User.Get(userRegion.RegionID, userID);

                if (disconnected && user.ConnectionStatus == UserConnectionStatus.Offline)
                {
                    continue;
                }

                if (disconnected && user.ConnectionStatus != UserConnectionStatus.Offline)
                {
                    foreach (var endpoint in group)
                    {
                        if (endpoint.IsConnected && endpoint.HeartbeatDate < DateTime.UtcNow.AddMinutes(-30))
                        {
                            endpoint.IsConnected = false;
                            endpoint.DisconnectedDate = DateTime.UtcNow;
                            endpoint.Update();
                        }
                    }
                    //UserStatusResolver.CreateOfflineResolver(user.UserID, "Tool");                    
                }

                Console.WriteLine("Found inconsistent status for user " + userID + " in region " + userRegion.RegionID);
            }

            Console.WriteLine("Done!");
            Console.ReadKey();
        }

        private static void FindInvalidOnlineUsers()
        {
            foreach (var config in AerospikeConfiguration.Configurations)
            {
                FindInvalidOnlineUsers(config);
            }
        }

        private static void FindInvalidOnlineUsers(AerospikeConfiguration config)
        {
            Console.WriteLine("Getting all non-offline users...");
            // Get all users that it thinks are online
            var onlineUsers = User.GetAll(config).Where(p => p.ConnectionStatus != UserConnectionStatus.Offline).ToArray();
            Console.WriteLine("Found " + onlineUsers.Length.ToString("###,##0") + " non-offline users!");


            var totalCount = onlineUsers.Length;
            var processedCount = 0;
            var invalidCount = 0;

            // Iterate over each of them, looking for a connected endpoint
            foreach (var user in onlineUsers)
            {
                if (++processedCount % 100 == 0)
                {
                    Console.Title = processedCount.ToString("###,##0") + " of " + totalCount.ToString("###,##0") + ". Invalid: " + invalidCount.ToString("###,##0");
                }

                var userEndpoints = ClientEndpoint.GetAllLocal(p => p.UserID, user.UserID);

                if (!userEndpoints.Any(p => p.IsConnected))
                {
                    // This user is not in a valid state                    
                    if (userEndpoints.Any(p => DateTime.UtcNow - p.ConnectedDate <= TimeSpan.FromMinutes(30) || DateTime.UtcNow - p.DisconnectedDate <= TimeSpan.FromMinutes(30)))
                    {
                        Console.WriteLine("Skipping user with a recently connected or disconnected endpoint!");
                    }
                    else
                    {
                        ++invalidCount;
                        Console.WriteLine("Found invalid user state. User: " + user.Username);
                        foreach (var ep in userEndpoints)
                        {
                            Console.WriteLine("Session Date: " + ep.SessionDate.ToLocalTime().ToString() + ", Connected Date: " + ep.ConnectedDate.ToLocalTime() + ", Disconnected Date: " + ep.DisconnectedDate.ToLocalTime());
                        }
                        //UserStatusResolver.CreateOfflineResolver(user.UserID, "No connected endpoints!");                        
                    }
                }
            }

            Console.WriteLine("--------------------------------------------");
            Console.WriteLine("Found " + invalidCount + " invalid users!");

        }

        private static void FindInvalidOfflineUsers()
        {
            foreach (var config in AerospikeConfiguration.Configurations)
            {
                FindInvalidOfflineUsers(config);
            }
        }

        /// <summary>
        /// Iterates over the user list, looking for users that have an offline status, but have a connected endpoint
        /// </summary>
        /// <param name="config"></param>
        private static void GetEndpointStats(AerospikeConfiguration config)
        {
            var totalCount = 0;
            var connectedCount = 0;
            var countByUser = new Dictionary<int, int>();
            var syncRoot = new object();

            ClientEndpoint.UpdateAllRecords(config, (key, record) =>
            {
                lock (syncRoot)
                {
                    ++totalCount;

                    // Get the status
                    if (totalCount % 100 == 0)
                    {
                        Console.WriteLine("Completed " + totalCount.ToString());
                    }

                    var userID = record.GetInt("UserID");
                    if (!record.bins.ContainsKey("IsConnected"))
                    {
                        return;
                    }

                    var isConnected = record.GetBool("IsConnected");

                    if (isConnected)
                    {
                        ++connectedCount;
                        if (!countByUser.ContainsKey(userID))
                        {
                            countByUser.Add(userID, 0);
                        }

                        ++countByUser[userID];
                    }
                }
            });
            Console.WriteLine("----------------------------------------------------------------------");
            Console.WriteLine("Total : " + totalCount.ToString("###,##0") + ", Connected: " + connectedCount);
            // Order
            var groupedCounts = countByUser.GroupBy(p => p.Value).Select(p => new { Endpoints = p.Key, Amount = p.Count() });
            foreach (var g in groupedCounts)
            {
                Console.WriteLine(g.Endpoints + ": " + g.Amount);
            }
        }


        /// <summary>
        /// Iterates over the user list, looking for users that have an offline status, but have a connected endpoint
        /// </summary>
        /// <param name="config"></param>
        private static void FindInvalidOfflineUsers(AerospikeConfiguration config)
        {
            var count = 0;
            var inconsistentCount = 0;
            var userIds = new HashSet<int>();

            User.UpdateAllRecords(config, (key, record) =>
            {
                // Get the status
                if (++count % 100 == 0)
                {
                    Console.WriteLine("Completed " + count.ToString());
                }

                var connectionStatus = record.GetInt("ConnStatus");
                if (connectionStatus != (int)UserConnectionStatus.Offline)
                {
                    return;
                }

                var userID = record.GetInt("UserID");
                var endpoints = ClientEndpoint.GetAll(config, p => p.UserID, userID);

                if (!endpoints.Any(p => p.IsConnected))
                {
                    return;
                }

                ++inconsistentCount;
                // User has a connected endpoint
                Console.WriteLine("Found a user that is connected, but has an Offline status: " + userID);

            }, false);

            Console.WriteLine("Found " + inconsistentCount + " inconsistent users!");
        }

        private static void OldFindInvalidOfflineUsers(AerospikeConfiguration config)
        {
            // Get all users that it thinks are online
            var offlineUsers = User.GetAll(config).Where(p => p.ConnectionStatus == UserConnectionStatus.Offline).ToArray();
            var endpoints = ClientEndpoint.GetAllLocal();

            var invalidCount = 0;

            // Iterate over each of them, looking for a connected endpoint
            foreach (var user in offlineUsers)
            {
                var userEndpoints = endpoints.Where(p => p.UserID == user.UserID).ToArray();

                if (userEndpoints.Any(p => p.IsConnected))
                {
                    ++invalidCount;


                    // This user is not in a valid state
                    Console.WriteLine("Found invalid user state. User: " + user.Username);
                    foreach (var ep in userEndpoints)
                    {
                        var age = DateTime.UtcNow - ep.ConnectedDate;
                        if (age > TimeSpan.FromMinutes(5))
                        {
                            Console.WriteLine("Resolving status...");
                            new UserStatusResolver
                            {
                                UserID = user.UserID,
                                Status = UserConnectionStatus.Online,
                                MachineKey = ep.MachineKey,
                                SessionID = ep.SessionID
                            }.Enqueue();
                        }
                        else
                        {
                            Console.WriteLine("Skipping recent endpopint!");
                        }
                        Console.WriteLine("Server: " + ep.ServerName + ", Sess: " + ep.SessionDate.ToLocalTime() + ", Conn: " + ep.ConnectedDate.ToLocalTime());
                    }
                }


            }

            Console.WriteLine("--------------------------------------------");
            Console.WriteLine("Found " + invalidCount + " invalid users!");

        }

        static void FindInvalidEndpoints()
        {
            var allEndpoints = ClientEndpoint.GetAllLocal();
            Console.WriteLine("Retrieved " + allEndpoints.Length + " endpoints!");
            var invalidCount = 0;
            foreach (var ep in allEndpoints)
            {
                if (ep.ConnectedDate > ep.DisconnectedDate && !ep.IsConnected)
                {
                    ++invalidCount;
                    Console.WriteLine("Found invalid endpoint!");
                }

                if (ep.ConnectedDate < ep.DisconnectedDate && ep.IsConnected)
                {
                    ++invalidCount;
                    Console.WriteLine("Found invalid endpoint!");
                }
            }

            Console.WriteLine("Found " + invalidCount + " invalid endpoints!");

        }

        private static void FixOfflineUsers()
        {
            UserStatusResolver.Initialize();

            Console.WriteLine("Getting all users...");

            var allUsers = User.GetAllLocal();

            Console.WriteLine("Retrieved " + allUsers.Length);

            var counter = 0;
            var total = allUsers.Length;
            var fixedOfflineCounter = 0;
            var fixedOnlineCounter = 0;

            // Get this user's friend list
            foreach (var user in allUsers)
            {
                ++counter;

                if (counter % 100 == 0)
                {
                    Console.WriteLine("User " + counter + " of " + total + "(Fixed Online: " + fixedOnlineCounter + ", Fixed Offline: " + fixedOfflineCounter + ")");
                }

                if (user.ConnectionStatus != UserConnectionStatus.Offline && user.ConnectionStatus != UserConnectionStatus.Invisible) // User is not offline or invisible
                {
                    var mostRecentEndpoint = ClientEndpoint.GetAllLocal(p => p.UserID, user.UserID).Where(p => p.IsConnected).OrderByDescending(p => p.ConnectedDate).FirstOrDefault();
                    if (mostRecentEndpoint == null)
                    {
                        ++fixedOfflineCounter;
                        //UserStatusResolver.CreateOfflineResolver(user.UserID, "No connected endpoints!");
                        continue;
                    }

                    var userFriends = Friendship.GetAllLocal(p => p.OtherUserID, user.UserID).Where(p => p.Status == FriendshipStatus.Confirmed);

                    if (userFriends.Any(p => p.OtherUserConnectionStatus == UserConnectionStatus.Offline))
                    {
                        // Get the most recent connected endpoint                        
                        ++fixedOnlineCounter;
                        UserStatusResolver.CreateStatusChangeResolver(user.UserID, user.ConnectionStatus, mostRecentEndpoint.MachineKey, mostRecentEndpoint.SessionID);
                    }
                }
            }

            Console.WriteLine("Done! Press enter to exit...");
            Console.ReadLine();

        }


        private static void WipeEndpointData()
        {
            WipeTable<ClientEndpoint>(1);
            WipeTable<UserClientEndpointMap>(1);
            WipeTable<Friendship>(1);
            WipeTable<UserStatistics>(1);
            WipeTable<FriendSuggestion>(1);

            //Friendship.BatchOperate(1, 1000, enumerable =>
            //{
            //    foreach (var friend in enumerable)
            //    {
            //        if (friend.OtherUserConnectionStatus != UserConnectionStatus.Offline)
            //        {
            //            friend.OtherUserConnectionStatus = UserConnectionStatus.Offline;
            //            friend.Update(p => p.OtherUserConnectionStatus);
            //        }                    
            //    }
            //});

            User.BatchOperate(1, 1000, enumerable =>
            {
                foreach (var friend in enumerable)
                {
                    if (friend.ConnectionStatus != UserConnectionStatus.Offline)
                    {
                        friend.ConnectionStatus = UserConnectionStatus.Offline;
                        friend.Update(p => p.ConnectionStatus);
                    }
                }
            });
        }

        private static void FixCorruptedFriends(AerospikeConfiguration config, int userID)
        {
            var otherFriends = Friendship.GetAll(config, p => p.OtherUserID, userID);

            if (!otherFriends.Any())
            {
                return;
            }

            foreach (var otherFriend in otherFriends)
            {
                FixFriend(config, otherFriend);
            }

        }

        private static void FixCorruptedGroups()
        {
            
        }

        private static void FixFriend(AerospikeConfiguration config, Friendship friendship)
        {
            var otherFriendship = Friendship.Get(config, friendship.OtherUserID, friendship.UserID);
            if (otherFriendship != null && (otherFriendship.UserID == 0 || otherFriendship.OtherUserID == 0))
            {
                // We must repair the other friendship, given this one
                var user = User.Get(config, friendship.UserID);
                if (user == null)
                {
                    Console.WriteLine("Failed to get user, skipping!");
                    return;
                }
                otherFriendship.UserID = friendship.OtherUserID;
                otherFriendship.OtherUserID = friendship.UserID;
                otherFriendship.DateConfirmed = friendship.DateConfirmed;
                otherFriendship.DateMessaged = friendship.DateMessaged;
                otherFriendship.DateRead = friendship.DateRead;
                otherFriendship.OtherUserNickname = user.Username;
                otherFriendship.OtherUsername = user.Username;
                otherFriendship.OtherUserRegionID = config.RegionIdentifier;

                if (friendship.Status == FriendshipStatus.Confirmed)
                {
                    otherFriendship.OtherUserAvatarUrl = user.AvatarUrl;
                    otherFriendship.OtherUserConnectionStatus = user.ConnectionStatus;
                    otherFriendship.OtherUserID = user.UserID;
                    otherFriendship.Status = FriendshipStatus.Confirmed;

                }
                else if (friendship.Status == FriendshipStatus.AwaitingThem)
                {
                    otherFriendship.Status = FriendshipStatus.AwaitingMe;
                }
                else if (friendship.Status == FriendshipStatus.AwaitingMe)
                {
                    otherFriendship.Status = FriendshipStatus.AwaitingThem;
                }
                else if (friendship.Status == FriendshipStatus.DeclinedByMe)
                {
                    otherFriendship.Status = FriendshipStatus.DeclinedByThem;
                }
                else if (friendship.Status == FriendshipStatus.DeclinedByThem)
                {
                    otherFriendship.Status = FriendshipStatus.DeclinedByMe;
                }
                else
                {
                    otherFriendship.Status = friendship.Status;
                }

                otherFriendship.IndexMode = IndexMode.Default;
                otherFriendship.Update(config);                
            }
        }

        private static void FixCorruptedFriendships(AerospikeConfiguration config)
        {
            var sm = new Statement();
            sm.SetNamespace("cursevoice-" + config.RegionGroup.ToLower());
            sm.SetSetName("Friendship");
            sm.SetIndexName("IDX_Friendship_UserID");

            var friendshipDict = new Dictionary<int, int>();
            var totalRecords = 0;

            using (var rs = config.Client.Query(null, sm))
            {

                while (rs.Next())
                {
                    try
                    {
                        var userID = rs.Record.GetInt("UserID");
                        var otherUserID = rs.Record.GetInt("OtherUserID");

                        if (userID > 0 && otherUserID > 0)
                        {
                            friendshipDict[userID] = otherUserID;
                        }
                        if (++totalRecords % 100 == 0)
                        {
                            Console.Title = "Read " + totalRecords.ToString("###,##0") + " records...";
                        }
                    }
                    catch (Exception ex)
                    {

                    }
                }
            }

            // Iterate over each frienship, looking for corrupted records
            var recordsProcessed = 0;
            var recordsUpdated = 0;
            foreach (var kvp in friendshipDict)
            {
                var userID = kvp.Key;
                var otherUserID = kvp.Value;

                try
                {
                    var friendship = Friendship.Get(config, userID, otherUserID);
                    if (friendship != null)
                    {
                        var otherFriendship = Friendship.Get(config, otherUserID, userID);
                        if (otherFriendship != null && (otherFriendship.UserID == 0 || otherFriendship.OtherUserID == 0))
                        {
                            // We must repair the other friendship, given this one
                            var user = User.Get(config, userID);
                            if (user == null)
                            {
                                Console.WriteLine("Failed to get user, skipping!");
                                continue;
                            }
                            otherFriendship.UserID = otherUserID;
                            otherFriendship.OtherUserID = userID;
                            otherFriendship.DateConfirmed = friendship.DateConfirmed;
                            otherFriendship.DateMessaged = friendship.DateMessaged;
                            otherFriendship.DateRead = friendship.DateRead;
                            otherFriendship.OtherUserNickname = user.Username;
                            otherFriendship.OtherUsername = user.Username;
                            otherFriendship.OtherUserRegionID = config.RegionIdentifier;

                            if (friendship.Status == FriendshipStatus.Confirmed)
                            {
                                otherFriendship.OtherUserAvatarUrl = user.AvatarUrl;
                                otherFriendship.OtherUserConnectionStatus = user.ConnectionStatus;
                                otherFriendship.OtherUserID = user.UserID;
                                otherFriendship.Status = FriendshipStatus.Confirmed;

                            }
                            else if (friendship.Status == FriendshipStatus.AwaitingThem)
                            {
                                otherFriendship.Status = FriendshipStatus.AwaitingMe;
                            }
                            else if (friendship.Status == FriendshipStatus.AwaitingMe)
                            {
                                otherFriendship.Status = FriendshipStatus.AwaitingThem;
                            }
                            else if (friendship.Status == FriendshipStatus.DeclinedByMe)
                            {
                                otherFriendship.Status = FriendshipStatus.DeclinedByThem;
                            }
                            else if (friendship.Status == FriendshipStatus.DeclinedByThem)
                            {
                                otherFriendship.Status = FriendshipStatus.DeclinedByMe;
                            }
                            else
                            {
                                otherFriendship.Status = friendship.Status;
                            }

                            otherFriendship.IndexMode = IndexMode.Default;
                            otherFriendship.Update(config);
                            ++recordsUpdated;
                        }
                    }
                }
                catch (Exception ex)
                {
                    Console.WriteLine("Error: " + ex.Message);
                }
                finally
                {
                    ++recordsProcessed;
                    if (recordsProcessed % 100 == 0)
                    {
                        Console.Title = "Processed " + recordsProcessed.ToString("###,##0") + ", Updated " + recordsUpdated.ToString("###,##0") + " of " + totalRecords.ToString("###,##0") + " records...";
                    }
                }                                
            }


        }

       

    }
}
