﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.Tracing
{
    public static class TracedUsers
    {
        private static readonly HashSet<string> TracedEmailDomains = new HashSet<string>
        {
            "@curse.com",
            "@twitch.tv",
            "@justin.tv",
            "@amazon.com"
        };
        #region WhitelistedIDs

        public static readonly HashSet<string> WhitelistedUserIDs = new HashSet<string>
        {
            "18651644","98692521","90280934","95679635","62564659", "99540689", "39789550", "55347167", "23886253", "95930043", "85552821", "99776559", "98845955", "25015105", "88048872", "61765754", "7969462", "43893913", "20606802", "17106792", "86366404", "21414718", "29011522", "101723804", "66601895", "119485101", "30375616", "22910290", "95309122", "101892326", "8650361", "13405587", "101776801", "102255672", "96046250", "149007525", "3240079", "6912855", "188563", "4221521", "7891708", "19609922", "9796851", "744132", "28701594", "36669366", "24362887", "32381716", "21229404", "50775713", "18686105", "37390536", "14619126", "18430542", "25045563", "13772077", "24671491", "14919816", "22395132", "24638328", "61845", "9173550", "37378928", "14783200", "8434", "27868415", "27254049", "26686797", "29581252", "60974588", "37569961", "634917", "24003689", "22158994", "474432", "25242039", "5582097", "27061009", "41469076", "21530987", "487780", "49713351", "61772429", "35790122", "15817895", "46940880", "12356205", "64366426", "28039860", "7965203", "65203692", "52863776", "62340995", "50295775", "45776283", "22554758", "28213853", "54599092", "75057012", "57248978", "76846095", "10047028", "74993064", "92403221", "91467751", "90422508", "94306060", "6917082", "14955393", "419941", "37374031", "65380937", "69932354", "11080225", "72335544", "107287572", "58746367", "32294188", "75882976", "101778362", "73430381", "13576693", "79659323", "38024066", "22749902", "62899086", "6316121", "90207377", "9370649", "10321308", "22449607", "95540308", "31863080", "97625892", "45573555", "107560080", "103838077", "102319147", "104465069", "104321839", "62660196", "104874624", "104329807", "95631521", "49370009", "101370283", "41521923", "104314137", "22975846", "102840624", "58798152", "37411485", "105271603", "101839314", "50707402", "96353013", "107459769", "108706200", "108707191", "105973857", "108999661", "21722773", "109784598", "1315120", "107306391", "111781970", "112095201", "128899663", "21457162", "141989500", "111925919", "109657733", "111997428", "118800034", "115415183", "19079059", "5124413", "105015331", "107526772", "112479096", "89614178", "112664877", "28173", "22630232", "113307014", "112571670", "106274887", "112570493", "88699593", "114059205", "119798703", "114063169", "88745792", "84392688", "23409799", "47060904", "65158718", "32302242", "32793631", "43640353", "23406143", "30531236", "114531176", "29273662", "17682660", "20944411", "115958605", "110052837", "32641670", "104314626", "42255566", "38950267", "66478830", "51758952", "37142314", "471453", "47897219", "13888449", "65409503", "94011", "12745158", "24308582", "125484138", "23829576", "83801381", "19662587", "51255232", "13366570", "20224161", "88055308", "24616648", "13857686", "89781387", "28801730", "23751188", "26621620", "121275425", "93654502", "2304258", "88135166", "90967891", "118726193", "112385159", "105959951", "132375056", "96901963", "72133163", "97317983", "102892846", "39214310", "19571752", "73612965", "24690580", "66820356", "109074509", "106199394", "77142092", "74428926", "3091868", "104314641", "18226428", "116708684", "70794406", "23972730", "107310007", "122235002", "6353604", "39398177", "65315830", "118463535", "116942807", "116709875", "116951674", "75174926", "109070760", "116910219", "107518888", "109480582", "118890019", "43376807", "114673704", "101365802", "124972907", "31557548", "62280044", "88926120", "113883999", "121001544", "98931001", "122777836", "91953474", "60199778", "114598718", "118192158", "29919503", "42372839", "123968916", "115308191", "117604356", "473396", "124980763", "47969748", "15584045", "93309212", "109632546", "126109146", "126149813", "123104539", "50208846", "40182316", "28337238", "45236021", "59018922", "31537114", "65203843", "41264107", "38400823", "130929861", "74020892", "28359887", "30840007", "52840459", "127615253", "28317653", "32102533", "20137474", "42856729", "83151597", "27310708", "87764551", "42197189", "22129289", "85901348", "130497739", "85528419", "23319307", "46957638", "89346272", "32055051", "80563772", "17272570", "128971049", "130624436", "70952524", "22960076", "96313631", "66239750", "96125320", "95546976", "109786824", "109735006", "103172921", "116250201", "117634199", "111697507", "118350923", "27697171", "118271634", "118374656", "118449209", "114892385", "45534323", "47425881", "39300104", "114259560", "41257196", "20624989", "120432097", "118790639", "27409150", "117583573", "119072097", "121636076", "115619030", "114063959", "121187233", "44322889", "105374863", "21461864", "119316908", "119455737", "122859157", "122806060", "123056178", "122961491", "123343211", "119691120", "123327266", "123338053", "122231871", "29903702", "123333107", "120131402", "28874214", "116810334", "120611973", "120119080", "90228952", "21029958", "76813770", "112548157", "116903498", "57354155", "24521454", "32264361", "107091026", "119677950", "124637903", "26991127", "7742782", "60092951", "60095892", "60873507", "57319306", "1839275", "62871885", "59607819", "31712139", "64158176", "66427164", "65772864", "57623709", "64192240", "67771987", "20814295", "38035433", "9364046", "40819772", "62876004", "39361778", "81728350", "20535208", "22234751", "22853164", "12835111", "87955434", "21892096", "24079611", "40964745", "47001519", "48659388", "96804149", "58861522", "21308644", "29743690", "101912472", "87220843", "121194877", "42806635", "18463390", "121174056", "49621176", "106284513", "85585314", "11997", "123889742", "124640290", "125059328", "125612718", "28059963", "5110586", "125700796", "125685247", "22564621", "29850191", "126275742", "126287428", "126286640", "121650561", "51040259", "126727576", "116076154", "87132", "118355373", "127323067", "124362472", "127380717", "96669348", "135711620", "85747855", "127897058", "118603638", "123456275", "45545070", "131094043", "128163439", "128179126", "128212677", "120899572", "128886556", "106687442", "128793876", "121355014", "128776159", "120424257", "129634297", "129663771", "31985780", "103801280", "55640847", "128787699", "18566725", "108446522", "130034508", "125277126", "120958305", "130541960", "130513376", "130546140", "14385770", "45919074", "39141793", "24535279", "46478688", "41582372", "992934", "22375345", "35775284", "36002799", "46581056", "7978979", "42256349", "23894415", "49709777", "123326118", "27953914", "48088439", "19629", "42390909", "31114496", "22389274", "41303670", "49676242", "38008931", "51837161", "51890023", "42253541", "90447500", "36352295", "36542349", "117406812", "29798286", "23716332", "55057042", "34465711", "1209504", "107769679", "30015604", "48910598", "60053408", "19112923", "61847817", "58757413", "29297972", "20213936", "19310937", "72536632", "81638511", "63033218", "83938032", "82457308", "21594587", "90850198", "59644777", "134755179", "89183447", "4832022", "55866615", "21456793", "95787431", "45867146", "31327358", "121123175", "36777584", "115789586", "78905201", "123968176", "124447984", "56538799", "125031579", "125167630", "125175606", "125246761", "125273514", "36413574", "125744906", "29857101", "126281641", "102440509", "126289493", "123171352", "126351976", "123065083", "85555774", "61879958", "126484437", "48778795", "103377580", "124115264", "125764878", "27222385", "60608720", "126273082", "26883731", "127636231", "57138723", "127618139", "88445877", "21231191", "75472529", "131169602", "131170029", "130967420", "131154232", "131180913", "93217725", "127316409", "131174082", "131607646", "127626243", "37045055", "131953837", "103615209", "85590103", "134690871", "35067996", "132312211", "132326474", "52223718", "132382029", "81476053", "104090116", "56681033", "99526743", "133337155", "51756334", "57319494", "133591338", "133588991", "44154013", "107591830", "56181436", "32316661", "133623973", "29105099", "70011879", "118832989", "38665491", "32274396", "36856635", "102647681", "46767338", "85309758", "48370582", "76603393", "47143096", "61907356", "25410421", "24358834", "126881671", "125116289", "133086566", "73906908", "76867", "134106291", "134111574", "133646686", "29726548", "119579624", "96316383", "49264822", "25320209", "22602760", "1682620", "98754253", "21658155", "127321363", "36861127", "22415610", "133715054", "64239424", "21687371", "14819886", "29744037", "51743340", "24070698", "134328152", "79920262", "92714955", "133120500", "134576600", "134155019", "57022584", "134680730", "133643350", "134697001", "126799586", "68831630", "12820576", "108341700", "135031865", "43528332", "135034325", "51543907", "135042352", "135096974", "130569396", "134815838", "38514247", "135086247", "130835933", "87206065", "135466536", "114581506", "102367120", "43278474", "135469655", "27419011", "51080661", "70516263", "41856403", "64756239", "70462555", "133123807", "27389919", "134991833", "57703126", "51386671", "116611571", "136349638", "15943448", "133779621", "54083979", "35009065", "124844921", "39356127", "136845570", "61084472", "136846010", "30515034", "132754217", "136935609", "136987121", "136976623", "124129369", "128900531", "130230403", "122937059", "62665789", "81624743", "89811488", "39018962", "136365832", "135815606", "23211159", "9321049", "137225933", "32519405", "123638268", "69183659", "138360643", "102439686", "138438690", "137317789", "138452255", "54703138", "138522981", "379382", "136800973", "138616809", "138617091", "138616921", "138743110", "115090392", "138431115", "82263243", "25369419", "139043545", "136452182", "136288163", "139263176", "139267107", "139503087", "134186189", "131434513", "138289128", "62177581", "139729295", "139804913", "99036101", "106064402", "38134082", "140651405", "134275038", "140612466", "136402652", "134684493", "41000714", "74681932", "139501692", "122879696", "107360582", "12871344", "39007908", "137256300", "58965043", "140708261", "135053914", "133812291", "141542809", "30908952", "136883259", "141860776", "106458964", "57585791", "139266000", "142043501", "111740869", "142125951", "29432474", "139806271", "29116175", "50890551", "139618069", "114594414", "135762134", "37289798", "144364159", "47392918", "144364086", "138357543", "139572014", "144585610", "102803728", "63759512", "144343593", "144106666", "110027261", "145359442", "23254891", "145894972", "145986533", "135093069", "42549188", "145992612", "142432472", "98745097", "85782307", "52196252", "146422262", "144550925", "79785465", "146508350", "146015430", "139228206", "138600452", "125107300", "135054130", "100783701", "38426833", "30961868", "146586785", "40514767", "42754592", "133085605", "118762610", "135219558", "146593057", "141679644", "77346255", "147215455", "147280858", "26579249", "141506021", "147432123", "147377315", "87644803", "141503350", "17089325", "147221033", "23353415", "54591721", "40529315", "147738413", "147864625", "147798184", "76940227", "62459522", "89644070", "21588923", "94568328", "46056451", "146557128", "148027928", "31362337", "30184051", "148406797", "21610241", "148461961", "140930188", "76001327", "148547479", "136796412", "91478666", "147810355", "147810285", "149750909", "28612965", "147810556", "147810600", "149011923",
            "149922681", "73192295", "85165016"
        };

        public static readonly HashSet<string> BackendDeveloperTwitchIDs = new HashSet<string>
        {
            "85165016", "134690871",
        };

        public static readonly HashSet<int> BackendDeveloperIDs = new HashSet<int>
        {
            1, 3, 18216731, 19483385, 29903403, 2245148, 30832486, 17870154
        };

        public static readonly HashSet<int> WhitelistedCurseUserIDs = new HashSet<int>
        {
            1, 3, 128, 817369
        };


        #endregion

        public static bool IsWhitelisted(string twitchUserID)
        {
            return WhitelistedUserIDs.Contains(twitchUserID);
        }

        public static bool IsWhitelisted(IEnumerable<string> twitchUserIDs)
        {
            if (twitchUserIDs == null)
            {
                return false;
            }

            foreach (var userID in twitchUserIDs)
            {
                if (WhitelistedUserIDs.Contains(userID))
                {
                    return true;
                }
            }

            return false;
        }

        public static bool IsWhitelisted(int curseUserID)
        {
            return WhitelistedCurseUserIDs.Contains(curseUserID);
        }

        public static bool IsDeveloper(int curseUserID)
        {
            return BackendDeveloperIDs.Contains(curseUserID);
        }

        public static bool IsInterestingUser(User user, ExternalAccount externalAccount, ExternalCommunity externalCommunity)
        {
            if (user != null)
            {
                if (IsWhitelisted(user.TwitchID))
                {
                    return true;
                }

                if (IsWhitelisted(user.UserID))
                {
                    return true;
                }

                if (TracedEmailDomains.Any(p => user.EmailAddress.ToEmptyWhenNull().EndsWith(p, StringComparison.InvariantCultureIgnoreCase)))
                {
                    return true;
                }
            }

            if (externalAccount != null)
            {
                if (IsWhitelisted(externalAccount.ExternalID))
                {
                    return true;
                }

                if (externalAccount.IsPartnered)
                {
                    return true;
                }
            }

            if (externalCommunity != null)
            {
                if (IsWhitelisted(externalCommunity.ExternalID))
                {
                    return true;
                }

                if (externalCommunity.IsPartnered)
                {
                    return true;
                }
            }

            return false;
        }

        public static bool IsDeveloper(User user)
        {
            if (user != null)
            {
                if (IsDeveloper(user.UserID))
                {
                    return true;
                }

            }
            
            return false;
        }

        public static bool IsDeveloper(string twitchID)
        {
            if(twitchID == null)
            {
                return false;
            }

            return BackendDeveloperTwitchIDs.Contains(twitchID);
        }

    }
}
