﻿using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class ChatBadgeResponse : ErrorableResponse
    {
        [JsonProperty("global_mod")]
        public ChatBadge GlobalMod { get; set; }

        [JsonProperty("admin")]
        public ChatBadge Admin { get; set; }

        [JsonProperty("broadcaster")]
        public ChatBadge Broadcaster { get; set; }

        [JsonProperty("mod")]
        public ChatBadge Mod { get; set; }

        [JsonProperty("staff")]
        public ChatBadge Staff { get; set; }

        [JsonProperty("turbo")]
        public ChatBadge Turbo { get; set; }

        [JsonProperty("subscriber")]
        public ChatBadge Subscriber { get; set; }
    }

    public class ChatBadge
    {
        [JsonProperty("alpha")]
        public string AlphaUrl { get; set; }

        [JsonProperty("image")]
        public string ImageUrl { get; set; }

        [JsonProperty("svg")]
        public string SvgUrl { get; set; }
    }
}
