﻿using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi.CurseShim
{
    public class MergeAccountPayload : ErrorableResponse
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }
        [JsonProperty("blocks")]
        public string[] BlockIDs { get; set; }
        [JsonProperty("friends")]
        public string[] FriendIDs { get; set; }
        [JsonProperty("outgoing_friend_requests")]
        public string[] FriendRequestIDs { get; set; }
        [JsonProperty("settings")]
        public MergeAccountSettings AccountSettings { get; set; }
    }

    public class MergeAccountSettings
    {
        [JsonProperty("share_activity")]
        public bool ShareActivity { get; set; }
        [JsonProperty("ignore_whispers_from_strangers")]
        public bool IgnoreWhispersFromStrangers { get; set; }
        [JsonProperty("is_invisible")]
        public bool IsInvisible { get; set; }
        [JsonProperty("is_whisper_banned")]
        public bool IsWhisperBanned { get; set; }
    }
}
