﻿using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class EmoticonResponse : ErrorableResponse
    {
        [JsonProperty("emoticons")]
        public TwitchEmoticon[] Emoticons { get; set; }
    }

    public class TwitchEmoticon
    {
        [JsonProperty("width")]
        public int Width { get; set; }

        [JsonProperty("height")]
        public int Height { get; set; }

        [JsonProperty("regex")]
        public string RegexString { get; set; }

        [JsonProperty("state")]
        public string State { get; set; }

        [JsonProperty("subscriber_only")]
        public bool SubscriberOnly { get; set; }

        [JsonProperty("url")]
        public string Url { get; set; }

        [JsonProperty("images")]
        public TwitchEmoticonImage[] Images { get; set; }
    }

    public class TwitchEmoticonImage
    {
        [JsonProperty("width")]
        public int Width { get; set; }

        [JsonProperty("height")]
        public int Height { get; set; }

        [JsonProperty("url")]
        public string Url { get; set; }

        [JsonProperty("emoticon_set")]
        public int? EmoticonSet { get; set; }
    }
}
