﻿using System;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class IteratorLinks
    {
        [JsonProperty("next")]
        public string Next { get; set; }

        [JsonProperty("self")]
        public string Self { get; set; }
    }

    public class UserFollowsResponse : ErrorableResponse
    {
        [JsonProperty("_links")]
        public IteratorLinks Links { get; set; }

        [JsonProperty("_total")]
        public int Total { get; set; }

        [JsonProperty("follows")]
        public Follow[] Follows { get; set; }
    }

    public class Follow : ErrorableResponse
    {
        [JsonProperty("created_at")]
        public DateTime CreatedAt { get; set; }

        [JsonProperty("notifications")]
        public bool Notifications { get; set; }

        [JsonProperty("channel")]
        public Channel Channel { get; set; }
    }

    public class Follower
    {
        [JsonProperty("created_at")]
        public DateTime CreatedDate { get; set; }

        [JsonProperty("notifications")]
        public bool Notifications { get; set; }

        [JsonProperty("user")]
        public User User { get; set; }
    }

    public class ChannelFollowsResponse : ErrorableResponse
    {
        [JsonProperty("_total")]
        public int Total { get; set; }

        [JsonProperty("_links")]
        public ChannelFollowersLinks Links { get; set; }

        [JsonProperty("_cursor")]
        public long Cursor { get; set; }

        [JsonProperty("follows")]
        public Follower[] Follows { get; set; }
    }

    public class ChannelFollowersLinks
    {
        [JsonProperty("self")]
        public string Self { get; set; }

        [JsonProperty("next")]
        public string Next { get; set; }
    }
}
