﻿using System.Collections.Generic;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class GlobalChatBadgesResponse : ErrorableResponse
    {
        [JsonProperty("badge_sets")]
        public Dictionary<string, ChatBadgeInfo> BadgeSets { get; set; }
    }

    public class ChatBadgeInfo
    {
        [JsonProperty("versions")]
        public Dictionary<string, ChatBadgeVersion> Versions { get; set; } 
    }

    public class ChatBadgeVersion
    {
        [JsonProperty("image_url_1x")]
        public string ImageUrl1x { get; set; }

        [JsonProperty("image_url_2x")]
        public string ImageUrl2x { get; set; }

        [JsonProperty("image_url_4x")]
        public string ImageUrl4x { get; set; }

        [JsonProperty("description")]
        public string Description { get; set; }

        [JsonProperty("title")]
        public string Title { get; set; }

        [JsonProperty("click_action")]
        public string ClickAction { get; set; }

        [JsonProperty("click_url")]
        public string ClickUrl { get; set; }
    }
}
