﻿using System;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class SubscriptionsResponse : ErrorableResponse
    {
        [JsonProperty("_total")]
        public int Total { get; set; }

        [JsonProperty("_links")]
        public IteratorLinks Links { get; set; }

        [JsonProperty("subscriptions")]
        public Subscription[] Subscriptions { get; set; }
    }

    public class Subscription : ErrorableResponse
    {
        [JsonProperty("_id")]
        public string ID { get; set; }

        [JsonProperty("user")]
        public User User { get; set; }

        [JsonProperty("created_at")]
        public DateTime CreatedAt { get; set; }

        [JsonProperty("_links")]
        public SubscriptionLink Links { get; set; }

        [JsonProperty("sub_plan")]
        public string Plan { get; set; }
    }

    public class SubscriptionLink
    {
        [JsonProperty("self")]
        public string Self { get; set; }
    }
}
