using Newtonsoft.Json;

namespace Curse.Friends.TwitchApi
{
    public class TwitchBaseInfo : ErrorableResponse
    {
        [JsonProperty("token")]
        public TwitchToken Token { get; set; }
    }

    public class TwitchToken
    {
        [JsonProperty("user_name")]
        public string UserName { get; set; }

        [JsonProperty("valid")]
        public bool Valid { get; set; }

        [JsonProperty("authorization")]
        public TokenAuthorizationInfo Authorization { get; set; }

        [JsonProperty("user_id")]
        public string UserID { get; set; }

        [JsonProperty("client_id")]
        public string ClientID { get; set; }
    }

    public class TokenAuthorizationInfo
    {
        [JsonProperty("created_at")]
        public string Created { get; set; }

        [JsonProperty("updated_at")]
        public string Updated { get; set; }

        [JsonProperty("scopes")]
        public string[] Scopes { get; set; }
    }
}