﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.TwitchApi
{
    public enum TwitchResponseStatus
    {
        GeneralError,
        Success,
        InvalidResponseFormat,
        Unauthorized,
        NotFound,
        Unprocessable,
        OtherNonSuccess,
        TwitchServerError,
        Timeout
    }

    public class TwitchResponse<T>
    {
        public T Value { get; private set; }

        public TwitchResponseStatus Status { get; private set; }

        public int StatusCode { get; private set; }

        public string Description { get; private set; }

        public object AdditionalInfo { get; private set; }

        public TwitchResponse(string description, T response, TwitchResponseStatus status, int statusCode = 0)
        {
            Value = response;
            Status = status;
            StatusCode = statusCode;
            Description = description;
        }

        public TwitchResponse(string description, TwitchResponseStatus errorStatus, int statusCode = 0, object additionalInfo = null)
        {
            if (errorStatus == TwitchResponseStatus.Success)
            {
                throw new InvalidOperationException();
            }

            Description = description;
            Status = errorStatus;
            StatusCode = statusCode;
            AdditionalInfo = additionalInfo;
        } 
    }
}
