﻿
using Curse.Friends.Enums;

namespace Curse.Friends.TwitchIdentityMerge
{
    public static class IdentityMergeServiceHelper
    {
        public static IdentityMergeState AutoProvisionAccount(string twitchID)
        {
            var resp = ServiceClients.FriendsServiceClients.Instance.LoginApi.AutoProvisionTwitchAccount(twitchID);
            if (!resp.Success)
            {
                return new IdentityMergeState(IdentityMergeFailureReason.GeneralError);
            }

            return new IdentityMergeState(resp.Response.TwitchUserID, resp.Response.CurseUserID, resp.Response.Username, resp.Response.DisplayName, IdentityMergeStatus.AutoProvisioned);
        }
    }
}
