﻿using Curse.Friends.Data;
using System;
using Curse.Friends.Enums;

namespace Curse.Friends.TwitchIdentityMerge
{
   
    public class IdentityMergeState
    {
        public IdentityMergeState(IdentityMergeStatus status)
        {
            if (status == IdentityMergeStatus.Failed)
            {
                throw new ArgumentException("Must supply a failure reason for failed.");
            }

            Status = status;            
            
        }

        public IdentityMergeState(IdentityMergeFailureReason failureReason)
        {
            Status = IdentityMergeStatus.Failed;
            FailureReason = failureReason;
        }

        public IdentityMergeState(string twitchUserID, int curseUserID, string username, string displayName, IdentityMergeStatus status = IdentityMergeStatus.Merged)
        {
            Status = status;
            TwitchUserID = twitchUserID;
            CurseUserID = curseUserID;
            Username = username;
            DisplayName = displayName;
        }

        public IdentityMergeStatus Status { get; set; }
        public IdentityMergeFailureReason FailureReason { get; set; }
        public string Username { get; set; }
        public string DisplayName { get; set; }
        public int CurseUserID { get; set; }
        public string TwitchUserID { get; set; }
    }
}

