﻿using System.Collections.Generic;

namespace Curse.Friends.TwitchIdentityMerge
{
    public class TwitchUserInfo
    {
        public string UserID { get; set; }
        public string ClientID { get; set; }
        public string AccessToken { get; set; }
        public string RefreshToken { get; set; }
        public string Username { get; set; }
        public string DisplayName { get; set; }
        public string Avatar { get; set; }
        public bool IsPartner { get; set; }        
        public string Bio { get; set; }
        public string Email { get; set; }        
        public bool EmailVerified { get; set; }
        public List<string> Scopes { get; set; }

        public TwitchUserInfo() {  }

        public TwitchUserInfo(TwitchApi.User twitchUser, TwitchApi.TwitchAccessTokenResponse token, string clientID)
        {
            UserID = twitchUser.ID;
            AccessToken = token.AccessToken;
            RefreshToken = token.RefreshToken;
            Username = twitchUser.Name;
            DisplayName = twitchUser.DisplayName;
            Avatar = twitchUser.Logo;
            IsPartner = twitchUser.Partnered;
            Scopes = token.Scope;
            Bio = twitchUser.Bio;
            Email = twitchUser.Email;
            EmailVerified = twitchUser.EmailVerified;
            ClientID = clientID;
        }
    }
}