﻿using Curse.Friends.Data.Models;
using System.Collections.Concurrent;
using Curse.Extensions;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using Curse.Logging;
using System;

namespace Curse.Friends.TwitchInterop
{
    public static class GameMapping
    {
        private static Dictionary<int, int> _curseToTwitchGameIDs = new Dictionary<int, int>();
        private static Dictionary<int, int> _twitchToCurseGameIDs = new Dictionary<int, int>();
        private static Dictionary<string, int> _twitchGameNameToCurseGameIDs = new Dictionary<string, int>(StringComparer.OrdinalIgnoreCase);

        static GameMapping()
        {
            LoadData();
        }

        public static void LoadData()
        {
            try
            {
                var items = TwitchGameMapping.GetAllLocal(x => x.IndexMode, Aerospike.IndexMode.Default);
                _curseToTwitchGameIDs = items.ToDictionary(x => x.CurseGameID, x => x.TwitchGameID);
                _twitchToCurseGameIDs = items.GroupBy(x => x.TwitchGameID).ToDictionary(x => x.Key, x => x.First().CurseGameID);

                var gameNameToGameID = new Dictionary<string, int>(StringComparer.OrdinalIgnoreCase);
                foreach (var game in items)
                {
                    gameNameToGameID[game.GameName] = game.CurseGameID;
                }

                _twitchGameNameToCurseGameIDs = gameNameToGameID;
            }
            catch(Exception ex)
            {
                Logger.Error(ex, "Failed to fetch Twitch-Curse game mappings");
            }
        }

        public static int GetTwitchID(int curseID)
        {
            return _curseToTwitchGameIDs.GetValueOrDefault(curseID);            
        }

        public static int GetCurseID(int twitchID)
        {
            return _twitchToCurseGameIDs.GetValueOrDefault(twitchID);
        }

        public static int GetCurseID(string gameName)
        {
            return _twitchGameNameToCurseGameIDs.GetValueOrDefault(gameName);
        }
    }
}
