﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Friends.Tracing;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchInterop
{
    public interface IUserContract
    {
        string UserID { get; set; }        
        FilteredUserLogger FilteredLogger { get; }    
        object GetLogData();
    }

    public interface IParticipantsContract : IUserContract
    {
        string[] ParticipantIDs { get; set; }
    }

    public interface ITargetUserContract : IUserContract
    {
        string TargetUserID { get; set; }
    }

    public static class BaseTwitchInteropContractExtensions
    {
        public static bool IsWhitelisted(this BaseTwitchInteropContract contract, out HashSet<string> participants)
        {
            var participantsContract = contract as IParticipantsContract;
            if (participantsContract != null)
            {
                var participantIDs = participantsContract.ParticipantIDs;
                if (participantIDs == null)
                {
                    participantIDs = new string[0];
                }
                if (participantIDs.Any(p => p == null))
                {
                    participantIDs = participantIDs.Where(p => p != null).ToArray();
                }

                participants = new HashSet<string>(participantIDs) { participantsContract.UserID };
                return TracedUsers.IsWhitelisted(participantsContract.UserID) && participantIDs.All(TracedUsers.IsWhitelisted);
            }

            var targetedContract = contract as ITargetUserContract;
            if (targetedContract != null)
            {
                participants = new HashSet<string> { targetedContract.UserID, targetedContract.TargetUserID };
                return TracedUsers.IsWhitelisted(targetedContract.UserID) && TracedUsers.IsWhitelisted(targetedContract.TargetUserID);
            }

            var userContract = contract as IUserContract;
            if (userContract != null)
            {
                participants = new HashSet<string> { userContract.UserID };
                return TracedUsers.IsWhitelisted(((IUserContract)contract).UserID);
            }

            participants = new HashSet<string>();
            return false;
        }
        public static bool IsWhitelisted(this BaseTwitchInteropContract contract)
        {
            HashSet<string> participants;
            return IsWhitelisted(contract, out participants);
        }

    }    

}
