﻿using Curse.Friends.UserEvents;
using System;
using Newtonsoft.Json;
using Curse.Logging;
using Curse.Friends.Data.Models;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("block_user")]
    public class BlockUserEventContract : BaseTwitchInteropContract<BlockUserEventContract, BlockUserEvent>, IUserContract
    {       
        [JsonProperty("user_id")]
        public string UserID { get; set; }

        [JsonProperty("target_user_id")]
        public string TargetUserID { get; set; }

        [JsonProperty("reason")]
        public string Reason { get; set; }

        [JsonProperty("source_context")]
        public string SourceContext { get; set; }

        protected override bool ProcessOutbound(BlockUserEvent evt)
        {
            var pair = evt.GetUserPair();

            if (!pair.HaveTwitchIDs)
            {
                return false;
            }
            
            UserID = pair.User.TwitchID;
            TargetUserID = pair.OtherUser.TwitchID;
            Reason = evt.Reason;

            switch (evt.Source)
            {                
                case BlockUserSource.PublicChat:
                    SourceContext = "chat";
                    break;
                case BlockUserSource.PrivateMessage:
                    SourceContext = "whisper";
                    break;
                default:
                    SourceContext = string.Empty;
                    break;
            }
            
            return true;
        }

        public override void ProcessInbound()
        {            
            var requestingUser = new MergedAccountProvider(UserID);
            var targetUser = new MergedAccountProvider(TargetUserID);

            string error = "";
            if(!requestingUser.Validate(out error) || !targetUser.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            UserBlock.ToggleBlock(requestingUser.InternalAccount, targetUser.InternalAccount, Enums.UserBlockStatus.Active);
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }

            if (string.IsNullOrWhiteSpace(TargetUserID))
            {
                LogValidation("Supressing: No TargetUserID");
                return false;
            }
                        
            return true; 
        }
    }
}
