﻿using Curse.Friends.Data;
using Curse.Friends.UserEvents;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("set_whisper_ban_status")]
    public class ConversationBanStatusEventContract : BaseTwitchInteropContract<ConversationBanStatusEventContract, ConversationBanStatusEvent>, IUserContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }
        [JsonProperty("is_banned")]
        public bool IsBanned { get; set; }

        protected override bool ProcessOutbound(ConversationBanStatusEvent evt)
        {
            var user = evt.GetUserStatistics();
            if(!user.HasTwitchID)
            {
                return false;
            }
            UserID = user.TwitchID;
            IsBanned = evt.IsBanned;
            return true;
        }

        public override void ProcessInbound()
        {
            var externalAccountProvider = new ExternalAccountProvider(UserID);
            string error = "";
            if(!externalAccountProvider.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            if(IsBanned)
            {
                UserBan.BanUser(externalAccountProvider.ExternalAccount.MergedUserID, Enums.UserBanType.Whisper);
            }
            else
            {
                UserBan.UnbanUser(externalAccountProvider.ExternalAccount.MergedUserID, Enums.UserBanType.Whisper);
            }
        }        

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }
            return true;
        }
    }
}
