﻿using Newtonsoft.Json;
using Curse.Friends.UserEvents;
using System;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("set_whisper_settings")]
    public class ConversationSettingsEventContract : BaseTwitchInteropContract<ConversationSettingsEventContract, ConversationSettingsEvent>, IUserContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }

        [JsonProperty("restrict_whispers")]
        public bool RestrictWhispers { get; set; }

        protected override bool ProcessOutbound(ConversationSettingsEvent evt)
        {
            var user = evt.GetUserStatistics();
            if (!user.HasTwitchID)
            {
                return false;
            }

            RestrictWhispers = evt.RestrictWhispers;
            UserID = user.TwitchID;
            return true;
        }

        public override void ProcessInbound()
        {
            var accountProvider = new MergedAccountProvider(UserID);
            string error = "";
            if (!accountProvider.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            var privacy = accountProvider.InternalAccount.GetPrivacy();
            privacy.BlockStrangerPMs = RestrictWhispers;
            privacy.Update(x => x.BlockStrangerPMs);
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }
            return true;
        }
    }
}
