﻿using Curse.Friends.Data.Models;
using Curse.Friends.UserEvents;
using Newtonsoft.Json;
using System.Linq;
using Curse.Friends.Enums;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("flag_whisper_spam")]
    public class FlagConversationSpamEventContract : BaseTwitchInteropContract<FlagConversationSpamEventContract, FlagConversationSpamEvent>, IUserContract, IParticipantsContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }
        [JsonProperty("participants")]
        public string[] ParticipantIDs { get; set; }
        [JsonProperty("is_spam")]
        public bool IsSpam { get; set; }

        protected override bool ProcessOutbound(FlagConversationSpamEvent evt)
        {            
            var pair = evt.GetUserPair();

            if (!pair.HaveTwitchIDs)
            {
                return false;
            }
                        
            UserID = pair.User.TwitchID;            
            ParticipantIDs = pair.ParticipantTwitchIDs;
            IsSpam = evt.IsSpam;

            return true;
        }    

        public override void ProcessInbound()
        {
            var requestingUser = new MergedAccountProvider(UserID);
            string error;
            if (!requestingUser.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            var otherID = ParticipantIDs.FirstOrDefault(x => x != UserID);
            var targetUser = new MergedAccountProvider(otherID);
            if (!targetUser.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            UserBlock.ToggleBlock(requestingUser.InternalAccount, targetUser.InternalAccount, IsSpam ? UserBlockStatus.Active : UserBlockStatus.Inactive);
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }

            if (ParticipantIDs == null || ParticipantIDs.Length == 0)
            {
                LogValidation("Supressing: Invalid Target IDs");
                return false;
            }

            if (ParticipantIDs.Any(x => x == null))
            {
                LogValidation("Supressing: Null participants found.");
                return false;
            }

            if (ParticipantIDs[0] == ParticipantIDs[1])
            {
                LogValidation("Supressing: ParticipantIDs match");
                return false;
            }

            return true; 
        }
    }
}
