﻿using Curse.Friends.UserEvents;
using Newtonsoft.Json;
using System;
using Curse.Extensions;
using Curse.Friends.Data;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("read_all_whispers")]
    public class MarkAllConversationReadEventContract : BaseTwitchInteropContract<MarkAllConversationReadEventContract, MarkAllConversationReadEvent>, IUserContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }
        [JsonProperty("timestamp")]
        public DateTime Timestamp { get; set; }

        public override void ProcessInbound()
        {
            var requestorAccountProvider = new ExternalAccountProvider(UserID);
            string error;
            if (!requestorAccountProvider.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            var utcTimestamp = Timestamp.NormalizeToUtc();

            var groupMemberships = GroupMember.GetAllByUserID(requestorAccountProvider.ExternalAccount.MergedUserID);
            foreach (var membership in groupMemberships)
            {
                membership.MarkAsRead(utcTimestamp);
            }

            var conversations = PrivateConversation.GetAllByUserID(requestorAccountProvider.ExternalAccount.MergedUserID);
            foreach (var conversation in conversations)
            {
                conversation.MarkAsRead(utcTimestamp);
            }

            ClientEndpoint.DispatchNotification(requestorAccountProvider.ExternalAccount.MergedUserID, endpoint =>
            {
                ConversationReadNotifier.Create(endpoint, new NotificationContracts.ConversationReadNotification { MarkAllAsRead = true });
            });            
        }        

        protected override bool ProcessOutbound(MarkAllConversationReadEvent evt)
        {
            var user = evt.GetUserStatistics();
            if(!user.HasTwitchID)
            {
                return false;
            }

            UserID = user.TwitchID;
            Timestamp = evt.Timestamp.FromEpochMilliconds();
            return true;
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }

            if (Timestamp == DateTime.MinValue)
            {
                LogValidation("Supressing: No Timestamp");
                return false;
            }
            return true; 
        }
    }
}
