﻿using System;
using Curse.Friends.UserEvents;
using Newtonsoft.Json;
using System.Linq;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("mute_whisper")]
    public class MuteConversationEventContract : BaseTwitchInteropContract<MuteConversationEventContract, MuteConversationEvent>, IUserContract, IParticipantsContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }

        [JsonProperty("participants")]
        public string[] ParticipantIDs { get; set; }

        [JsonProperty("is_muted")]
        public bool IsMuted { get; set; }

        protected override bool ProcessOutbound(MuteConversationEvent evt)
        {
            var pair = evt.GetSenderAndRecipient();

            if (!pair.HaveTwitchIDs)
            {
                return false;
            }


            UserID = pair.User.TwitchID;
            ParticipantIDs = pair.ParticipantTwitchIDs;
            return false;
        }

        public override void ProcessInbound()
        {
            var whisperInfo = WhisperHelper.GetWhisperInfo(UserID, ParticipantIDs, false);
            
            if (!whisperInfo.IsValid)
            {
                LogEvent("Supressing due to validation or merge state.", whisperInfo.ValidationData);
                return;
            }

            whisperInfo.ToggleMuted(IsMuted);
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }

            if (ParticipantIDs == null || ParticipantIDs.Length != 2)
            {
                LogValidation("Supressing: Invalid Participant IDs");
                return false;
            }

            if (ParticipantIDs.Any(x => x == null))
            {
                LogValidation("Supressing: Null participants found.");
                return false;
            }

            if (ParticipantIDs[0] == ParticipantIDs[1])
            {
                LogValidation("Supressing: ParticipantIDs match");
                return false;
            }
            return true;
        }
    }
}
