﻿using Curse.Friends.Data;
using Curse.Friends.UserEvents;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Extensions;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("unban_user")]
    public class UnbanUserContract : BaseTwitchInteropContract<UnbanUserContract, UnbanUserEvent>, IUserContract
    {
        [JsonProperty("user_id")]
        public string UserID { get; set; }
        [JsonProperty("timestamp")]
        public DateTime Timestamp { get; set; }

        // we should be only be receiving this, not sending to twitch. 
        protected override bool ProcessOutbound(UnbanUserEvent evt)
        {            
            throw new NotImplementedException();
        }

        public override void ProcessInbound()
        {
            var accountProvider = new ExternalAccountProvider(UserID);
            string error = "";
            if (!accountProvider.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            if (UserBan.IsBannedFrom(accountProvider.ExternalAccount.MergedUserID, Enums.UserBanType.Social))
            {
                UserBan.UnbanUser(accountProvider.ExternalAccount.MergedUserID, Enums.UserBanType.Social);
                var userStatistic = UserStatistics.GetByUserID(accountProvider.ExternalAccount.MergedUserID);

                userStatistic.TokenTimestamp = DateTime.UtcNow.ToEpochMilliseconds();
                userStatistic.Update(x => x.TokenTimestamp);
            }

        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }
            if (Timestamp == DateTime.MinValue)
            {
                LogValidation("Supressing: No Timestamp");
                return false;
            }
            return true;
        }

    }
}
