﻿using Curse.Friends.UserEvents;
using System;
using Newtonsoft.Json;
using Curse.Logging;
using Curse.Friends.Data.Models;

namespace Curse.Friends.TwitchInterop.V1
{
    [TwitchInteropContract("unblock_user")]
    public class UnblockUserEventContract : BaseTwitchInteropContract<UnblockUserEventContract, UnblockUserEvent>, IUserContract, ITargetUserContract
    {       
        [JsonProperty("user_id")]
        public string UserID { get; set; }

        [JsonProperty("target_user_id")]
        public string TargetUserID { get; set; }

        protected override bool ProcessOutbound(UnblockUserEvent evt)
        {
            var pair = evt.GetUserPair();

            if (!pair.HaveTwitchIDs)
            {
                return false;
            }

           UserID = pair.User.TwitchID;
           TargetUserID = pair.OtherUser.TwitchID;
           return true;
        }

        public override void ProcessInbound()
        {
            var requestingUser = new MergedAccountProvider(UserID);
            var targetUser = new MergedAccountProvider(TargetUserID);

            string error = "";
            if (!requestingUser.Validate(out error) || !targetUser.Validate(out error))
            {
                LogValidation(string.Format("Supressing: {0}", error));
                return;
            }

            UserBlock.ToggleBlock(requestingUser.InternalAccount, targetUser.InternalAccount, Enums.UserBlockStatus.Inactive);
        }

        public override bool Validate()
        {
            if (string.IsNullOrWhiteSpace(UserID))
            {
                LogValidation("Supressing: No UserID");
                return false;
            }
            if (string.IsNullOrWhiteSpace(TargetUserID))
            {
                LogValidation("Supressing: No TargetID");
                return false;
            }
            if (UserID == TargetUserID)
            {
                LogValidation("Supressing: UserID and TargetID cannot match.");
                return false;
            }
            return true;
        }
    }
}
