﻿using System.Xml.Serialization;
using Curse.Friends.Configuration;
using Curse.Friends.Data;

namespace Curse.Friends.TwitchInteropService.Configuration
{
    public enum AwsCredentialType
    {
        Basic,
        AssumeRole,
        InstanceProfile
    }

    [XmlType("TwitchInterop")]
    public class TwitchInteropConfiguration
    {
        private static readonly TwitchInteropConfiguration _instance;

        public static TwitchInteropConfiguration Instance { get { return _instance; } }

        static TwitchInteropConfiguration()
        {
#if CONFIG_RELEASE
            var mode = ConfigurationMode.Release;
#else
            var mode = ConfigurationMode.Debug;
#endif

            _instance = ConfigurationHelper.LoadConfiguration<TwitchInteropConfiguration>(mode, "TwitchInterop");
        }

        [XmlElement]
        public bool KinesisEnabled { get; set; }

        [XmlArray("Streams")]
        [XmlArrayItem("Stream")]
        public TwitchInteropConnectionInfo[] KinsesisStreams { get; set; }  
      
        [XmlElement]
        public TwitchInteropConnectionInfo ConsumerQueue { get; set; }

        [XmlElement("ConsumerEnabled")]
        public bool ConsumerEnabled { get; set; }

        [XmlElement("PublisherEnabled")]
        public bool PublisherEnabled { get; set; }

        [XmlElement]
        public TwitchInteropConnectionInfo PublisherQueue { get; set; }

        [XmlElement("AuthenticationServiceUrl")]
        public string AuthenticationServiceUrl { get; set; }

        [XmlElement("AuthenticationServiceSiteID")]
        public int AuthenticationServiceSiteID { get; set; }

        [XmlElement("AuthenticationServiceSiteKey")]
        public string AuthenticationServiceSiteKey { get; set; }

        [XmlElement]
        public bool UseWhitelist { get; set; }

        [XmlElement]
        public bool StreamQueuesEnabled { get; set; }

        [XmlElement]
        public TwitchInteropConnectionInfo StreamUpQueue { get; set; }

        [XmlElement]
        public TwitchInteropConnectionInfo StreamDownQueue { get; set; }
    }

    public class TwitchInteropConnectionInfo
    {
        [XmlElement]
        public KinesisAccountSource Account { get; set; }

        [XmlElement]
        public AwsCredentialType CredentialType { get; set; }

        [XmlElement]
        public string RoleArn { get; set; }

        [XmlElement]
        public string StreamName { get; set; }

        [XmlElement]
        public string RegionEndpoint { get; set; }

        [XmlElement]
        public string UserAccessKey { get; set; }

        [XmlElement]
        public string UserAccessSecret { get; set; }      
    }
}
