﻿using System;
using Curse.Friends.Configuration;
using Curse.Friends.ServerHosting;

namespace Curse.Friends.TwitchInteropService
{
    partial class CurseTwitchInteropService : CurseWindowsService
    {
        public CurseTwitchInteropService()
        {
            InitializeComponent();
        }

        protected override ServiceHostType HostType
        {
            get { return ServiceHostType.TwitchInterop; }
        }

        protected override ConfigurationServices ConfigurationServices
        {
            get { return ConfigurationServices.Database | ConfigurationServices.Queue | ConfigurationServices.TwitchApi | ConfigurationServices.Search; }
        }

        protected override void CustomStartup()
        {
            TwitchInteropServer.Instance.Start();
        }

        protected override void CustomStop()
        {
            TwitchInteropServer.Instance.Stop();
        }
    }
}
