﻿using System;
using System.Linq;
using System.Threading;
using Curse.Aerospike;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.TwitchApi;
using Curse.Logging;

namespace Curse.Friends.TwitchInteropService.Processors
{
    class ChattersListProcessor
    {
        private static readonly LogCategory Logger = new LogCategory("ChattersListProcessor") {Throttle = TimeSpan.FromMinutes(5), ReleaseLevel = LogLevel.Debug};
        private static CurseShimClient _client;
        private static readonly string _serverID = $"curse-{Environment.MachineName}";

        public static void Initialize(string authToken, string baseUrl)
        {
            _client = new CurseShimClient(authToken, baseUrl);
        }

        public static void Process(ChattersListWorker worker)
        {
            if (_client == null)
            {
                Logger.Error("Curse Shim Client was not initialized, cannot process chatters list");
                return;
            }

            var chatters = worker.ChattersList;

            var attempt = 0;
            TwitchResponse<ErrorableResponse> response;
            do
            {
                response = _client.SendChattersList(_serverID, chatters);

                if (response.Status == TwitchResponseStatus.Success)
                {
                    return;
                }

                if (response.Status == TwitchResponseStatus.NotFound || response.StatusCode == 404)
                {
                    Logger.Warn("Failed to send chatters list, endpoint not found, not attempting to retry", new {chatters, response});
                    return;
                }

                attempt++;
                Thread.Sleep(1000);
            } while (attempt < 5);

            Logger.Warn($"Failed to send chatters list after {attempt} attempts", new {chatters, response});
        }
    }
}
