﻿using System;
using System.Diagnostics;
using System.ServiceProcess;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchInteropService
{
    class Program
    {
        static void Main(string[] args)
        {            
            if (Debugger.IsAttached)
            {
                var service = new CurseTwitchInteropService();
                Console.Write("Starting Twitch Interop Service...");
                service.OnDebugStart();
                Console.WriteLine("Done");
                        
                Console.WriteLine("Press enter to stop the service");
                Console.ReadLine();
                service.OnDebugStop();
            }
            else
            {
                ServiceBase.Run(new ServiceBase[] { new CurseTwitchInteropService() });
            }
        }
    }
}
