﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace Curse.Friends.TwitchInteropService.Sqs
{
    public class SqsConsumedMessage
    {
        public string Type { get; set; }

        [JsonProperty("MessageId")]
        public Guid MessageID { get; set; }

        public string TopicArn { get; set; }

        public string Message { get; set; }

        public DateTime Timestamp { get; set; }

        public string SignatureVersion { get; set; }

        public string Signature { get; set; }

        [JsonProperty("SigningCertURL")]
        public string SigningCertUrl { get; set; }

        [JsonProperty("UnsubscribeURL")]
        public string UnsubscribeUrl { get; set; }

        public Dictionary<string, MessageAttribute> MessageAttributes { get; set; } 
    }

    public class MessageAttribute
    {
        public string Type { get; set; }

        public object Value { get; set; }
    }
}
