﻿using System;
using Curse.Friends.TwitchInteropService.Configuration;
using Curse.Friends.TwitchInteropService.Sqs.Processors;
using Curse.Friends.TwitchInteropService.Sqs.StreamStatus;
using Curse.Logging;

namespace Curse.Friends.TwitchInteropService.Sqs
{
    class SqsManager
    {
        private static BaseSqsConsumer _consumerQueue;
        private static BaseSqsConsumer _streamUpConsumer;
        private static BaseSqsConsumer _streamDownConsumer;
        private static SqsPublisher _publisher;
 
        public static void Start(bool consumerEnabled, bool publisherEnabled)
        {
            if (consumerEnabled)
            {
                var consumerConfig = TwitchInteropConfiguration.Instance.ConsumerQueue;
                if (consumerConfig == null)
                {
                    throw new InvalidOperationException("SQS consumer config is missing");
                }

                _consumerQueue = new InteropConsumer(consumerConfig);
                _consumerQueue.Start();

                var streamUpConfig = TwitchInteropConfiguration.Instance.StreamUpQueue;
                if (streamUpConfig == null)
                {
                    throw new InvalidOperationException("SQS Stream Up config is missing");
                }
                _streamUpConsumer = new StreamUpConsumer(streamUpConfig);
                _streamUpConsumer.Start();

                var streamDownConfig = TwitchInteropConfiguration.Instance.StreamDownQueue;
                if (streamDownConfig == null)
                {
                    throw new InvalidOperationException("SQS Stream Up config is missing");
                }
                _streamDownConsumer = new StreamDownConsumer(streamDownConfig);
                _streamDownConsumer.Start();
            }
            else
            {
                Logger.Info("SQS Consumer will not be run.");
            }

            if (publisherEnabled)
            {
                var publisherConfig = TwitchInteropConfiguration.Instance.PublisherQueue;
                if (publisherConfig == null)
                {
                    throw new InvalidOperationException("SQS publisher config is missing");
                }
                _publisher = SqsPublisher.Create(publisherConfig);
            }
            else
            {
                Logger.Info("SQS Publisher will not be run.");
            }
        }

        public static void Stop()
        {
            _consumerQueue?.Stop();
            _streamDownConsumer?.Stop();
            _streamUpConsumer?.Stop();
        }

        public static SqsPublisher GetPublisher()
        {
            return _publisher;
        }
    }
}
