﻿using System.Threading;

namespace Curse.Friends.TwitchInteropService.Stats
{
    public class KinesisStreamStats
    {
        private long _totalEventsProcessed;
        private long _totalEventSkipped;
        private long _eventsProcessedSinceLastReport;
        private long _eventsSkippedSinceLastReport;

        public void EventProcessed()
        {
            Interlocked.Increment(ref _totalEventsProcessed);
            Interlocked.Increment(ref _eventsProcessedSinceLastReport);
        }

        public void EventSkipped()
        {
            Interlocked.Increment(ref _totalEventSkipped);
            Interlocked.Increment(ref _eventsSkippedSinceLastReport);
        }

        public object GetReport()
        {
            var totalProcessedSnapshot = Interlocked.Read(ref _totalEventsProcessed);
            var totalSkippedSnapshot = Interlocked.Read(ref _totalEventSkipped);            

            var processedSnapshot = Interlocked.Exchange(ref _eventsProcessedSinceLastReport, 0);
            var skippedSnapshot = Interlocked.Exchange(ref _eventsSkippedSinceLastReport, 0);
            
            return new
            {
                TotalProcessed = totalProcessedSnapshot,
                EventsProcessedSinceLastReport = processedSnapshot,

                TotalSkipped = totalSkippedSnapshot,
                EventsSkippedSinceLastReport = skippedSnapshot
                
            };
        }
    }
}
