﻿using System.Threading;

namespace Curse.Friends.TwitchInteropService.Stats
{
    public class SqsConsumerStats
    {
        private long _totalEventsProcessed;
        private long _eventsProcessedSinceLastReport;

        private long _totalUnprocessableEvents;
        private long _unprocessableEventsSinceLastReport;

        private long _totalFailures;
        private long _failuresSinceLastReport;

        private long _totalSkipped;
        private long _skippedSinceLastReport;

        public void EventProcessed()
        {
            Interlocked.Increment(ref _totalEventsProcessed);
            Interlocked.Increment(ref _eventsProcessedSinceLastReport);
        }

        public void UnprocessableEvent()
        {
            Interlocked.Increment(ref _totalUnprocessableEvents);
            Interlocked.Increment(ref _unprocessableEventsSinceLastReport);
        }

        public void EventFailed()
        {
            Interlocked.Increment(ref _totalFailures);
            Interlocked.Increment(ref _failuresSinceLastReport);
        }

        public void EventSkipped()
        {
            Interlocked.Increment(ref _totalSkipped);
            Interlocked.Increment(ref _skippedSinceLastReport);
        }

        public object GetReport()
        {
            var totalProcessedSnapshot = Interlocked.Read(ref _totalEventsProcessed);
            var processedSnapshot = Interlocked.Exchange(ref _eventsProcessedSinceLastReport, 0);

            var totalUnprocessableSnapshot = Interlocked.Read(ref _totalUnprocessableEvents);
            var unprocessableSnapshot = Interlocked.Exchange(ref _unprocessableEventsSinceLastReport, 0);

            var totalFailuresSnapshot = Interlocked.Read(ref _totalFailures);
            var failuresSnapshot = Interlocked.Exchange(ref _failuresSinceLastReport, 0);

            var totalSkippedSnapshot = Interlocked.Read(ref _totalSkipped);
            var skippedSnapshot = Interlocked.Exchange(ref _skippedSinceLastReport, 0);

            return new
            {
                TotalProcessed = totalProcessedSnapshot,
                EventsProcessedSinceLastReport = processedSnapshot,

                TotalUnprocessable = totalUnprocessableSnapshot,
                UnprocessableSinceLastReport = unprocessableSnapshot,

                TotalFailures = totalFailuresSnapshot,
                FailuresSinceLastReport = failuresSnapshot,

                TotalSkipped = _totalSkipped,
                SkippedSinceLastReport = skippedSnapshot
            };
        }
    }
}
