﻿using System.Threading;

namespace Curse.Friends.TwitchInteropService.Stats
{
    public class SqsPublisherStats
    {
        private long _totalEventsSent;
        private long _totalEventsFailed;
        private long _eventsSentSinceLastReport;
        private long _eventsFailedSinceLastReport;

        public void EventSent()
        {
            Interlocked.Increment(ref _totalEventsSent);
            Interlocked.Increment(ref _eventsSentSinceLastReport);
        }

        public void EventFailed()
        {
            Interlocked.Increment(ref _totalEventsFailed);
            Interlocked.Increment(ref _eventsFailedSinceLastReport);
        }

        public object GetReport()
        {
            var totalSentSnapshot = Interlocked.Read(ref _totalEventsSent);
            var totalFailedSnapshot = Interlocked.Read(ref _totalEventsFailed);

            var sentSnapshot = Interlocked.Exchange(ref _eventsSentSinceLastReport, 0);
            var failedSnapshot = Interlocked.Exchange(ref _eventsFailedSinceLastReport, 0);

            return new
            {
                TotalSent = totalSentSnapshot,
                EventsSentSinceLastReport = sentSnapshot,

                TotalFailed = totalFailedSnapshot,
                EventsFailedSinceLastReport = failedSnapshot

            };
        }
    }
}
