﻿using System;
using System.Threading;
using Curse.Logging;

namespace Curse.Friends.TwitchInteropService.Stats
{
    class StatsTracker
    {
        private static DateTime _startTime;
        private static readonly Timer _timer = new Timer(ProcessStats, null, Timeout.Infinite, Timeout.Infinite);

        public static readonly KinesisStreamStats IdentityStreamStats = new KinesisStreamStats();
        public static readonly KinesisStreamStats UserMutationStreamStats = new KinesisStreamStats();
        
        public static readonly SqsConsumerStats SqsConsumerStats = new SqsConsumerStats();
        public static readonly SqsPublisherStats SqsPublisherStats = new SqsPublisherStats();
        public static readonly SqsConsumerStats SqsStreamDownStats = new SqsConsumerStats();
        public static readonly SqsConsumerStats SqsStreamUpStats = new SqsConsumerStats();

        public static readonly UserEventStats UserEventStats = new UserEventStats();


        public static void Start()
        {
            _startTime = DateTime.UtcNow;
            _timer.Change(TimeSpan.FromMinutes(1), TimeSpan.FromMinutes(1));
        }

        public static void Stop()
        {
            _timer.Change(Timeout.Infinite, Timeout.Infinite);
            _timer.Dispose();
        }

        private static void ProcessStats(object state)
        {
            try
            {
                Logger.Info("Publishing Periodic Stats", new
                {
                    ServiceStarted = _startTime,
                    IdentityStream = IdentityStreamStats.GetReport(),
                    UserMutationStream = UserMutationStreamStats.GetReport(),

                    SQSConsumerQueue = SqsConsumerStats.GetReport(),
                    SQSPublisherQueue = SqsPublisherStats.GetReport(),

                    StreamUpQueue = SqsStreamUpStats.GetReport(),
                    StreamDownQueue = SqsStreamDownStats.GetReport(),

                    UserEvents = UserEventStats.GetReportData(),
                });
            }
            catch (Exception ex)
            {
                Logger.Error(ex, "Error processing stats");
            }
        }
    }
}
