﻿using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Threading;

namespace Curse.Friends.TwitchInteropService.Stats
{
    public class UserEventStats
    {
        private ConcurrentDictionary<string, CountStat> _stats = new ConcurrentDictionary<string, CountStat>();
        private ConcurrentDictionary<string, CountStat> _totals = new ConcurrentDictionary<string, CountStat>();

        public void TrackEvent(string name)
        {
            var reportInfo = _stats.GetOrAdd(name, new CountStat());
            var totalsInfo = _totals.GetOrAdd(name, new CountStat());

            Interlocked.Increment(ref reportInfo.Count);
            Interlocked.Increment(ref totalsInfo.Count);
        }

        public object GetReportData()
        {
            var reportDict = _stats;
            _stats = new ConcurrentDictionary<string, CountStat>();

            var counts = new Dictionary<string, ReportData>();

            foreach(var kvp in _totals)
            {
                var data = new ReportData
                {
                    Total = kvp.Value.Count
                };

                CountStat since;
                if(reportDict.TryGetValue(kvp.Key, out since))
                {
                    data.SinceLastReport = since.Count;
                }

                counts[kvp.Key] = data;
            }

            return counts;
        }

        private class ReportData
        {
            public long Total { get; set; }

            public long SinceLastReport { get; set; }
        }

        private class CountStat
        {
            public long Count;
        }
    }
}
