﻿using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.MicroService;
using Curse.Friends.TwitchInteropWebService.Configuration;
using Curse.Friends.TwitchInteropWebService.Contracts;
using System.Linq;
using System.Web.Http;
using System.Web.Http.Description;

namespace Curse.Friends.TwitchInteropWebService.Controllers
{
    [ExcludeFromGenerator]
    [RoutePrefix("twitch-shim")]
    public class TwitchShimController : MicroServiceController
    {
        [HttpGet]
        [Route("mobile-endpoints/{twitchID}")]
        [ResponseType(typeof(HasMobileEndpointResponse))]
        [AuthenticationFilter(AuthenticationLevel.Anonymous)]
        public IHttpActionResult HasMobileEndpoint(string twitchID)
        {
            var header = Request.Headers.Select(h => new { h.Key, h.Value }).FirstOrDefault(h => h.Key == "X-API-Key"); ;
            if (header == null || header.Value.All(v => v != TwitchInteropConfiguration.Instance.ApiKey))
            {
                return Forbidden();
            }

            var acct = ExternalAccount.GetLocal(twitchID, AccountType.Twitch);
            if (acct == null || acct.MergedUserID == 0)
            {
                return NotFound(new HasMobileEndpointResponse
                {
                    HasMobileEndpoint = false
                });
            }

            var endpoints = ClientEndpoint.GetAllDeliverable(acct.MergedUserID).Where(m => m.IsMobile).ToArray();
            return Ok(new HasMobileEndpointResponse { HasMobileEndpoint = endpoints.Length > 0 });
        }
    }
}