﻿using System.Net.Sockets;
using System.Threading;

namespace Curse.Friends.TwitchService.Chat.Irc
{
    class TrackingTcpClient : TcpClient
    {
        private static long _clientsCreatedTotal;
        private static long _clientsCreated;

        private static long _clientsDisposedTotal;
        private static long _clientsDisposed;

        private static long _clientsClosedTotal;
        private static long _clientsClosed;

        public TrackingTcpClient(string hostname, int port) : base(hostname, port)
        {
            Interlocked.Increment(ref _clientsCreated);
            Interlocked.Increment(ref _clientsCreatedTotal);
        }

        public TrackingTcpClient(AddressFamily family) : base(family)
        {
            Interlocked.Increment(ref _clientsCreated);
            Interlocked.Increment(ref _clientsCreatedTotal);
        }

        public new void Close()
        {
            try
            {
                base.Close();
            }
            finally
            {
                Interlocked.Increment(ref _clientsClosed);
                Interlocked.Increment(ref _clientsClosedTotal);
            }
        }

        protected override void Dispose(bool disposing)
        {
            try
            {
                base.Dispose(disposing);
            }
            finally
            {
                Interlocked.Increment(ref _clientsDisposed);
                Interlocked.Increment(ref _clientsDisposedTotal);
            }
        }

        public static object GetTrackingReport()
        {
            var created = Interlocked.Read(ref _clientsCreatedTotal);
            var createdSinceLast = Interlocked.Exchange(ref _clientsCreated, 0L);
            var closed = Interlocked.Read(ref _clientsClosedTotal);
            var closedSinceLast = Interlocked.Exchange(ref _clientsClosed, 0L);
            var disposed = Interlocked.Read(ref _clientsDisposedTotal);
            var disposedSinceLast = Interlocked.Exchange(ref _clientsDisposed, 0L);

            return new
            {
                CreatedClients = created,
                CreatedClientsSinceLastReport = createdSinceLast,
                ClosedClients = closed,
                ClosedClientsSinceLastReport = closedSinceLast,
                DisposedClients = disposed,
                DisposedClientsSinceLastReport = disposedSinceLast,
            };
        }
    }
}
