﻿using System;
using System.Collections.Generic;
using Curse.Extensions;
using Curse.Friends.Data.Messaging;
using Curse.Friends.Enums;
using Curse.Friends.TwitchService.Chat.Parsing;

namespace Curse.Friends.TwitchService.Chat
{
    public class TwitchMessage
    {
        public TwitchMessage()
        {
            
        }

        public TwitchMessage(IrcMessageType messageType, TwitchChatNoticeType noticeType, Dictionary<TwitchChatTag, object> tags, string messageBody, string username, string channelName)
        {
            MessageType = messageType;
            NoticeType = noticeType;
            ChannelName = channelName;
            Data = messageBody;
            Username = username;
            Tags = tags;

            // Tags derived common data
            EmoteSubstitutions = TwitchMessageParser.ResolveEmoteSubstitutions((TwitchEmoteSubstitution[]) tags.GetValueOrDefault(TwitchChatTag.Emotes), messageBody);
            UserDisplayName = TwitchMessageParser.GetTagStringValue((string) tags.GetValueOrDefault(TwitchChatTag.DisplayName));
            Timestamp = (long) (tags.GetValueOrDefault(TwitchChatTag.Timestamp) ?? 0L);
            UserID = (long) (tags.GetValueOrDefault(TwitchChatTag.UserId) ?? 0L);
            UserColor = (string) tags.GetValueOrDefault(TwitchChatTag.Color);
            BroadcasterLanguage = (string) tags.GetValueOrDefault(TwitchChatTag.BroadcasterLanguage);
            Bits = (int) (tags.GetValueOrDefault(TwitchChatTag.Bits) ?? 0);
            ChannelID = (long)(tags.GetValueOrDefault(TwitchChatTag.RoomId) ?? 0L);
            Badges = TwitchMessageParser.GetBadges((TwitchBadge[])tags.GetValueOrDefault(TwitchChatTag.Badges), ChannelID);
            MessageID = TwitchMessageParser.GetMessageID((string) tags.GetValueOrDefault(TwitchChatTag.Id));
        }

        public Guid MessageID;

        public IrcMessageType MessageType { get; set; }

        public TwitchChatNoticeType NoticeType { get; set; }

        public long UserID { get; set; }

        public string Username { get; set; }

        public string UserDisplayName { get; set; }

        public string ChannelName { get; set; }

        public long ChannelID { get; set; }

        public string Data { get; set; }

        public long Timestamp { get; set; }

        public ConversationMessageEmoteSubstitution[] EmoteSubstitutions { get; set; }

        public ConversationMessageBadge[] Badges { get; set; }

        public Dictionary<TwitchChatTag, object> Tags { get; set; }

        public string UserColor { get; set; }

        public string BroadcasterLanguage { get; set; }

        public int Bits { get; set; }
    }
}
