﻿using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using Curse.Friends.Configuration;

namespace Curse.Friends.TwitchService.Configuration
{
    [XmlRoot("TwitchService")]
    public class TwitchServiceConfiguration
    {
        private static readonly TwitchServiceConfiguration _instance;

        public static TwitchServiceConfiguration Instance { get { return _instance; } }

        static TwitchServiceConfiguration()
        {
            var configPath = FindConfigPath();

            var serializer = new XmlSerializer(typeof (TwitchServiceConfiguration));
            _instance = (TwitchServiceConfiguration) serializer.Deserialize(new XmlTextReader(File.OpenRead(configPath)));
        }

        private static string FindConfigPath()
        {
            var basePath = AppDomain.CurrentDomain.BaseDirectory;
            var filename = string.Format("TwitchService.{0}.config", FriendsServiceConfiguration.Mode);
            var configPath = Path.Combine(basePath, filename);
            if (File.Exists(configPath))
            {
                return configPath;
            }

            configPath = Path.Combine(basePath, "Configuration", filename);
            if (File.Exists(configPath))
            {
                return configPath;
            }

            configPath = Path.Combine(basePath, "bin", filename);
            if (File.Exists(configPath))
            {
                return configPath;
            }

            configPath = Path.Combine(basePath, "bin", "Configuration", filename);
            if (File.Exists(configPath))
            {
                return configPath;
            }

            throw new InvalidOperationException(string.Format("{0} could not be found in any expected location.", filename));
        }

        [XmlElement]
        public string TwitchBotUsername { get; set; }

        [XmlElement]
        public string TwitchBotToken { get; set; }

        [XmlElement]
        public int ModSyncIntervalMinutes { get; set; }

        public TimeSpan ModSyncInterval { get { return TimeSpan.FromMinutes(ModSyncIntervalMinutes); } }

        [XmlElement]
        public int SubscriberSyncIntervalMinutes { get; set; }

        public TimeSpan SubscriberSyncInterval { get { return TimeSpan.FromMinutes(SubscriberSyncIntervalMinutes); } }

        [XmlElement]
        public int EmoticonSyncIntervalMinutes { get; set; }

        public TimeSpan EmoticonSyncInterval { get { return TimeSpan.FromMinutes(EmoticonSyncIntervalMinutes); } }

        [XmlElement]
        public int TaskParallelism { get; set; }

        [XmlElement]
        public int FullSyncIntervalMinutes { get; set; }

        [XmlElement]
        public int UserSessionWindowMinutes { get; set; }

        [XmlElement]
        public int BucketCount { get; set; }
    }
}
