﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Curse.Aerospike;
using Curse.CloudServices.Jobs;
using Curse.Extensions;
using Curse.Friends.Data;
using Curse.Friends.Enums;
using Curse.Friends.TwitchApi;
using Curse.Friends.TwitchService.Configuration;
using Curse.Logging;

namespace Curse.Friends.TwitchService.Jobs
{
    public class TwitchGlobalBadgeSyncJob : BaseJob
    {
        public override JobScheduleMode ScheduleMode
        {
            get { return JobScheduleMode.Interval; }
        }

        public override bool OnlyDefaultRegion
        {
            get { return true; }
        }

        public override int RunFrequencyMinutes
        {
            get { return TwitchServiceConfiguration.Instance.FullSyncIntervalMinutes; }
        }

        public override void Run()
        {
            var globalBadges = TwitchApiHelper.Default.GetGlobalChatBadges();
            if (globalBadges.Status != TwitchResponseStatus.Success)
            {
                Logger.Debug("Failed to get global badges from Twitch", globalBadges);
                return;
            }

            var descriptors = TwitchBadgeDescriptor.GetDescriptors(globalBadges.Value).GroupBy(b => TwitchChatBadge.GetAvatarEntityID(b.BadgeSet, b.Version)).ToDictionary(g => g.Key, g => g.First());
            var allExisting = TwitchChatBadge.GetAllGlobals().ToDictionary(b => b.GetAvatarEntityID());
            var avatars = Avatar.MultiGetLocal(allExisting.Select(e => new KeyInfo((int)AvatarType.TwitchChatBadge, e.Value.GetAvatarEntityID()))).ToDictionary(a => a.EntityID);
            foreach (var descriptor in descriptors)
            {
                descriptor.Value.UpdateModel(allExisting.GetValueOrDefault(descriptor.Key), null, avatars.GetValueOrDefault(descriptor.Key));
            }

            foreach (var existing in allExisting)
            {
                TwitchBadgeDescriptor descriptor;
                if (descriptors.TryGetValue(existing.Key, out descriptor) || existing.Value.IsDeleted)
                {
                    continue;
                }

                existing.Value.IsDeleted = true;
                existing.Value.Update();

                var entityID = existing.Key;
                var avatar = Avatar.GetLocal((int)AvatarType.TwitchChatBadge, entityID);
                if (avatar == null || string.IsNullOrEmpty(avatar.Url))
                {
                    // Already deleted or missing, no avatar update needed
                    continue;
                }

                AvatarUpdatePump.UpdateAvatar(AvatarType.TwitchChatBadge, entityID, string.Empty);
            }
        }
    }
}
