﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Curse.Friends.TwitchService
{
    public class SimpleMovingAverage
    {
        private readonly object _syncRoot = new object();

        private readonly int _sampleSize;
        private readonly List<double> _samples;

        public double LastAverage { get; private set; }

        public DateTime LastAverageTimestamp { get; private set; }

        public SimpleMovingAverage(int sampleSize)
        {
            _sampleSize = sampleSize;
            _samples = new List<double>(_sampleSize);
        }

        public void AddSample(double sample)
        {
            lock (_syncRoot)
            {
                _samples.Add(sample);

                if (_samples.Count == _sampleSize)
                {
                    LastAverage = _samples.Average();
                    LastAverageTimestamp = DateTime.UtcNow;
                    _samples.Clear();
                }
            }
        }

        public object ToSerializeable()
        {
            return new
            {
                Average = LastAverage,
                Timestamp = LastAverageTimestamp
            };
        }
    }
}
